/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Schema(name="Extensible", description="Base Extensible schema for use in TMForum Open-APIs - When used for in a schema it means that the Entity described by the schema  MUST be extended with the @type")
public class Extensible {
    @JsonProperty(value="@type")
    private String atType;
    @JsonProperty(value="@baseType")
    private String atBaseType;
    @JsonProperty(value="@schemaLocation")
    private String atSchemaLocation;

    public Extensible() {
    }

    public Extensible(String atType) {
        this.atType = atType;
    }

    public Extensible atType(String atType) {
        this.atType = atType;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getAtType() {
        return this.atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public Extensible atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtBaseType() {
        return this.atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public Extensible atSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtSchemaLocation() {
        return this.atSchemaLocation;
    }

    public void setAtSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extensible extensible = (Extensible)o;
        return Objects.equals(this.atType, extensible.atType) && Objects.equals(this.atBaseType, extensible.atBaseType) && Objects.equals(this.atSchemaLocation, extensible.atSchemaLocation);
    }

    public int hashCode() {
        return Objects.hash(this.atType, this.atBaseType, this.atSchemaLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Extensible {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.atType)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.atSchemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

