/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Schema(name="EventSubscription", description="Sets the communication endpoint address the service instance must use to deliver notification information")
public class EventSubscription {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="callback")
    private String callback;
    @JsonProperty(value="query")
    private String query;

    public EventSubscription() {
    }

    public EventSubscription(String id, String callback) {
        this.id = id;
        this.callback = callback;
    }

    public EventSubscription id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="Id of the listener", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EventSubscription callback(String callback) {
        this.callback = callback;
        return this;
    }

    @NotNull
    @Schema(name="callback", description="The callback being registered.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public EventSubscription query(String query) {
        this.query = query;
        return this;
    }

    @Schema(name="query", description="additional data to be passed", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSubscription eventSubscription = (EventSubscription)o;
        return Objects.equals(this.id, eventSubscription.id) && Objects.equals(this.callback, eventSubscription.callback) && Objects.equals(this.query, eventSubscription.query);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.callback, this.query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventSubscription {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    callback: ").append(this.toIndentedString(this.callback)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

