/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;

@Schema(name="Error", description="Used when an API throws an Error, typically with a HTTP error response-code (3xx, 4xx, 5xx)")
public class Error
extends BaseRootEntity {
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="reason")
    private String reason;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="referenceError")
    private String referenceError;

    public Error() {
    }

    public Error(String atType, String code, String reason) {
        this.type = atType;
        this.code = code;
        this.reason = reason;
    }

    public Error code(String code) {
        this.code = code;
        return this;
    }

    @NotNull
    @Schema(name="code", description="Application relevant detail, defined in the API or a common list.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Error reason(String reason) {
        this.reason = reason;
        return this;
    }

    @NotNull
    @Schema(name="reason", description="Explanation of the reason for the error which can be shown to a client user.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Error message(String message) {
        this.message = message;
        return this;
    }

    @Schema(name="message", description="More details and corrective actions related to the error which can be shown to a client user.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error status(String status) {
        this.status = status;
        return this;
    }

    @Schema(name="status", description="HTTP Error code extension", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Error referenceError(String referenceError) {
        this.referenceError = referenceError;
        return this;
    }

    @Schema(name="referenceError", description="URI of documentation describing the error.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getReferenceError() {
        return this.referenceError;
    }

    public void setReferenceError(String referenceError) {
        this.referenceError = referenceError;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.type, error.type) && Objects.equals(this.baseType, error.baseType) && Objects.equals(this.schemaLocation, error.schemaLocation) && Objects.equals(this.code, error.code) && Objects.equals(this.reason, error.reason) && Objects.equals(this.message, error.message) && Objects.equals(this.status, error.status) && Objects.equals(this.referenceError, error.referenceError);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.code, this.reason, this.message, this.status, this.referenceError);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    @type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    @baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    @schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    referenceError: ").append(this.toIndentedString(this.referenceError)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

