/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.gsm674.model.HourPeriod;

@Entity(name="CalendarPeriod")
public class CalendarPeriod
extends BaseRootEntity {
    @JsonProperty(value="day")
    private String day;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="timeZone")
    private String timeZone;
    @JsonProperty(value="id")
    private String id;
    @Valid
    @JsonProperty(value="hourPeriod")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    List<HourPeriod> hourPeriod = new ArrayList<HourPeriod>();

    public CalendarPeriod() {
    }

    public CalendarPeriod(String status) {
        this.status = status;
    }

    public CalendarPeriod id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="unique identifier of the calendar period", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CalendarPeriod day(String day) {
        this.day = day;
        return this;
    }

    @Schema(name="day", description="Day where the calendar status applies (e.g.: monday, mon-to-fri, weekdays, weekend, all week, ...)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="day")
    public String getDay() {
        return this.day;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public CalendarPeriod timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Schema(name="timeZone", description="Indication of the timezone applicable to the calendar information (e.g.: Paris, GMT+1)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public CalendarPeriod hourPeriod(List<HourPeriod> hourPeriod) {
        this.hourPeriod = hourPeriod;
        return this;
    }

    public CalendarPeriod addHourPeriodItem(HourPeriod hourPeriodItem) {
        if (this.hourPeriod == null) {
            this.hourPeriod = new ArrayList<HourPeriod>();
        }
        this.hourPeriod.add(hourPeriodItem);
        return this;
    }

    @Valid
    @Schema(name="hourPeriod", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hourPeriod")
    public List<HourPeriod> getHourPeriod() {
        return this.hourPeriod;
    }

    public void setHourPeriod(List<HourPeriod> hourPeriod) {
        this.hourPeriod = hourPeriod;
    }

    public CalendarPeriod status(String status) {
        this.status = status;
        return this;
    }

    @NotNull
    @Schema(name="status", description="Indication of the availability of the caledar period (e.g.: available, booked, etc.)", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarPeriod calendarPeriod = (CalendarPeriod)o;
        return Objects.equals(this.schemaLocation, calendarPeriod.schemaLocation) && Objects.equals(this.baseType, calendarPeriod.baseType) && Objects.equals(this.type, calendarPeriod.type) && Objects.equals(this.href, calendarPeriod.href) && Objects.equals(this.id, calendarPeriod.id) && Objects.equals(this.day, calendarPeriod.day) && Objects.equals(this.timeZone, calendarPeriod.timeZone) && Objects.equals(this.hourPeriod, calendarPeriod.hourPeriod) && Objects.equals(this.status, calendarPeriod.status);
    }

    public int hashCode() {
        return Objects.hash(this.schemaLocation, this.baseType, this.type, this.href, this.id, this.day, this.timeZone, this.hourPeriod, this.status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CalendarPeriod {\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    day: ").append(this.toIndentedString(this.day)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    hourPeriod: ").append(this.toIndentedString(this.hourPeriod)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

