/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.gsm674.model.Entity;
import org.etsi.osl.tmf.gsm674.model.GeographicSiteAttributeValueChangeEvent;
import org.etsi.osl.tmf.gsm674.model.GeographicSiteCreateEvent;
import org.etsi.osl.tmf.gsm674.model.GeographicSiteDeleteEvent;
import org.etsi.osl.tmf.gsm674.model.GeographicSiteStateChangeEvent;
import org.springframework.format.annotation.DateTimeFormat;

@JsonIgnoreProperties(value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=BaseEvent.class, name="BaseEvent"), @JsonSubTypes.Type(value=GeographicSiteAttributeValueChangeEvent.class, name="GeographicSiteAttributeValueChangeEvent"), @JsonSubTypes.Type(value=GeographicSiteCreateEvent.class, name="GeographicSiteCreateEvent"), @JsonSubTypes.Type(value=GeographicSiteDeleteEvent.class, name="GeographicSiteDeleteEvent"), @JsonSubTypes.Type(value=GeographicSiteStateChangeEvent.class, name="GeographicSiteStateChangeEvent")})
public class BaseEvent
extends Entity {
    @JsonProperty(value="event")
    private Object event;
    @JsonProperty(value="eventId")
    private String eventId;
    @JsonProperty(value="eventTime")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime eventTime;
    @JsonProperty(value="eventType")
    private String eventType;
    @JsonProperty(value="correlationId")
    private String correlationId;
    @JsonProperty(value="domain")
    private String domain;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="priority")
    private String priority;
    @JsonProperty(value="timeOcurred")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime timeOcurred;

    public BaseEvent() {
    }

    public BaseEvent(String href, String id, String atType) {
        super(href, id, atType);
    }

    public BaseEvent event(Object event) {
        this.event = event;
        return this;
    }

    @Schema(name="event", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Object getEvent() {
        return this.event;
    }

    public void setEvent(Object event) {
        this.event = event;
    }

    public BaseEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(name="eventId", description="The identifier of the notification.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public BaseEvent eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Valid
    @Schema(name="eventTime", description="Time of the event occurrence.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public BaseEvent eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(name="eventType", description="The type of the notification.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public BaseEvent correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Schema(name="correlationId", description="The correlation id for this event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public BaseEvent domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(name="domain", description="The domain of the event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public BaseEvent title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="The title of the event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BaseEvent description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="An explanatory of the event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BaseEvent priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(name="priority", description="A priority.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public BaseEvent timeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
        return this;
    }

    @Valid
    @Schema(name="timeOcurred", description="The time the event occured.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public OffsetDateTime getTimeOcurred() {
        return this.timeOcurred;
    }

    public void setTimeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
    }

    @Override
    public BaseEvent href(String href) {
        super.href(href);
        return this;
    }

    @Override
    public BaseEvent id(String id) {
        super.id(id);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEvent baseEvent = (BaseEvent)o;
        return Objects.equals(this.event, baseEvent.event) && Objects.equals(this.eventId, baseEvent.eventId) && Objects.equals(this.eventTime, baseEvent.eventTime) && Objects.equals(this.eventType, baseEvent.eventType) && Objects.equals(this.correlationId, baseEvent.correlationId) && Objects.equals(this.domain, baseEvent.domain) && Objects.equals(this.title, baseEvent.title) && Objects.equals(this.description, baseEvent.description) && Objects.equals(this.priority, baseEvent.priority) && Objects.equals(this.timeOcurred, baseEvent.timeOcurred) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.event, this.eventId, this.eventTime, this.eventType, this.correlationId, this.domain, this.title, this.description, this.priority, this.timeOcurred, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseEvent {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    timeOcurred: ").append(this.toIndentedString(this.timeOcurred)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

