/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.fi691.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.fi691.model.GeographicAddressType;
import org.etsi.osl.tmf.fi691.model.IdentificationType;
import org.etsi.osl.tmf.fi691.model.UserAssetType;
import org.springframework.validation.annotation.Validated;

@Validated
@Entity(name="UserInfoType")
public class UserInfoType
extends BaseRootNamedEntity {
    @JsonProperty(value="sub")
    private String sub = null;
    @JsonProperty(value="given_name")
    private String givenName = null;
    @JsonProperty(value="family_name")
    private String familyName = null;
    @JsonProperty(value="middle_name")
    private String middleName = null;
    @JsonProperty(value="nickname")
    private String nickname = null;
    @JsonProperty(value="preferred_username")
    private String preferredUsername = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="phone_number")
    private String phoneNumber = null;
    @JsonProperty(value="gender")
    private String gender = null;
    @JsonProperty(value="birthdate")
    private String birthdate = null;
    @JsonProperty(value="locale")
    private String locale = null;
    @JsonProperty(value="zoneinfo")
    private String zoneinfo = null;
    @JsonProperty(value="profile")
    private String profile = null;
    @JsonProperty(value="picture")
    private String picture = null;
    @JsonProperty(value="website")
    private String website = null;
    @JsonProperty(value="address")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(referencedColumnName="uuid")
    private GeographicAddressType address = null;
    @JsonProperty(value="legalId")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<IdentificationType> legalId = new HashSet<IdentificationType>();
    @JsonProperty(value="userAssets")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<UserAssetType> userAssets = new HashSet<UserAssetType>();

    public UserInfoType sub(String sub) {
        this.sub = sub;
        return this;
    }

    @Schema(description="Subject - Unique Identifier for the End-User")
    @NotNull
    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public UserInfoType givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Schema(description="Given name(s) or first name(s) of the End-User. Note that in some cultures, people can have multiple given names; all can be present, with the names being separated by space characters")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public UserInfoType familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Schema(description="Surname(s) or last name(s) of the End-User. Note that in some cultures, people can have multiple family names or no family name; all can be present, with the names being separated by space characters")
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public UserInfoType middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    @Schema(description="Middle name(s) of the End-User. Note that in some cultures, people can have multiple middle names; all can be present, with the names being separated by space characters. Also note that in some cultures, middle names are not used")
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public UserInfoType nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @Schema(description="Casual name of the End-User that may or may not be the same as the given_name. For instance, a nickname value of Mike might be returned alongside a given_name value of Michael")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public UserInfoType preferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
        return this;
    }

    @Schema(description="Shorthand name by which the End-User wishes to be referred to at the RP, such as janedoe or j.doe. This value MAY be any valid JSON string including special characters such as @, /, or whitespace")
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    public void setPreferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
    }

    public UserInfoType email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="End-User's preferred e-mail address. Its value MUST conform to the [RFC5322] addr-spec syntax")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserInfoType phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Schema(description="End-User's preferred telephone number. [E.164] is RECOMMENDED as the format of this Claim, for example, +1 (425) 555-1212 or +56 82) 687 2400. If the phone number contains an extension, it is RECOMMENDED that the extension be represented using the [RFC3966] extension syntax, for example, +1 (604) 555-1234;ext=5678")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public UserInfoType gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Schema(description="End-User's gender. Values defined by this specification are female and male. Other values MAY be used when neither of the defined values are applicable")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public UserInfoType birthdate(String birthdate) {
        this.birthdate = birthdate;
        return this;
    }

    @Schema(description="End-User's birthday, represented as an [ISO8601-2004] YYYY-MM-DD format. The year MAY be 0000, indicating that it is omitted. To represent only the year, YYYY format is allowed. Note that depending on the underlying platform's date related function, providing just year can result in varying month and day, so the implementers need to take this factor into account to correctly process the dates")
    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public UserInfoType locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Schema(description="End-User's locale, represented as a [RFC5646] language tag. This is typically an [ISO639-1] language code in lowercase and an [ISO3166-1] country code in uppercase, separated by a dash. For example, en-US or fr-CA. As a compatibility note, some implementations have used an underscore as the separator rather than a dash, for example, en_US")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public UserInfoType zoneinfo(String zoneinfo) {
        this.zoneinfo = zoneinfo;
        return this;
    }

    @Schema(description="String from zoneinfo time zone database representing the End-User's time zone. For example, Europe/Paris or America/Los_Angeles")
    public String getZoneinfo() {
        return this.zoneinfo;
    }

    public void setZoneinfo(String zoneinfo) {
        this.zoneinfo = zoneinfo;
    }

    public UserInfoType profile(String profile) {
        this.profile = profile;
        return this;
    }

    @Schema(description="URL of the End-User's profile page. The contents of this Web page SHOULD be about the End-User")
    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public UserInfoType picture(String picture) {
        this.picture = picture;
        return this;
    }

    @Schema(description="URL of the End-User's profile picture. This URL MUST refer to an image file (for example, a PNG, JPEG, or GIF image file), rather than to a Web page containing an image. Note that this URL SHOULD specifically reference a profile photo of the End-User suitable for displaying when describing the End-User, rather than an arbitrary photo taken by the End-User")
    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public UserInfoType website(String website) {
        this.website = website;
        return this;
    }

    @Schema(description="URL of the End-User's Web page or blog. This Web page SHOULD contain information published by the End-User or an organization that the End-User is affiliated with")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public UserInfoType address(GeographicAddressType address) {
        this.address = address;
        return this;
    }

    @Schema(description="Structure including the End-User's preferred postal address")
    @Valid
    public GeographicAddressType getAddress() {
        return this.address;
    }

    public void setAddress(GeographicAddressType address) {
        this.address = address;
    }

    public UserInfoType legalId(Set<IdentificationType> legalId) {
        this.legalId = legalId;
        return this;
    }

    public UserInfoType addLegalIdItem(IdentificationType legalIdItem) {
        if (this.legalId == null) {
            this.legalId = new HashSet<IdentificationType>();
        }
        this.legalId.add(legalIdItem);
        return this;
    }

    @Schema(description="Identification documentation of the contact")
    @Valid
    public Set<IdentificationType> getLegalId() {
        return this.legalId;
    }

    public void setLegalId(Set<IdentificationType> legalId) {
        this.legalId = legalId;
    }

    public UserInfoType userAssets(Set<UserAssetType> userAssets) {
        this.userAssets = userAssets;
        return this;
    }

    public UserInfoType addUserAssetsItem(UserAssetType userAssetsItem) {
        if (this.userAssets == null) {
            this.userAssets = new HashSet<UserAssetType>();
        }
        this.userAssets.add(userAssetsItem);
        return this;
    }

    @Schema(description="List of additional profile information")
    @Valid
    public Set<UserAssetType> getUserAssets() {
        return this.userAssets;
    }

    public void setUserAssets(Set<UserAssetType> userAssets) {
        this.userAssets = userAssets;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfoType userInfoType = (UserInfoType)o;
        return Objects.equals(this.sub, userInfoType.sub) && Objects.equals(this.name, userInfoType.name) && Objects.equals(this.givenName, userInfoType.givenName) && Objects.equals(this.familyName, userInfoType.familyName) && Objects.equals(this.middleName, userInfoType.middleName) && Objects.equals(this.nickname, userInfoType.nickname) && Objects.equals(this.preferredUsername, userInfoType.preferredUsername) && Objects.equals(this.email, userInfoType.email) && Objects.equals(this.phoneNumber, userInfoType.phoneNumber) && Objects.equals(this.gender, userInfoType.gender) && Objects.equals(this.birthdate, userInfoType.birthdate) && Objects.equals(this.locale, userInfoType.locale) && Objects.equals(this.zoneinfo, userInfoType.zoneinfo) && Objects.equals(this.profile, userInfoType.profile) && Objects.equals(this.picture, userInfoType.picture) && Objects.equals(this.website, userInfoType.website) && Objects.equals(this.address, userInfoType.address) && Objects.equals(this.legalId, userInfoType.legalId) && Objects.equals(this.userAssets, userInfoType.userAssets) && Objects.equals(this.type, userInfoType.type) && Objects.equals(this.baseType, userInfoType.baseType) && Objects.equals(this.schemaLocation, userInfoType.schemaLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserInfoType {\n");
        sb.append("    sub: ").append(this.toIndentedString(this.sub)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    middleName: ").append(this.toIndentedString(this.middleName)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    preferredUsername: ").append(this.toIndentedString(this.preferredUsername)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("    birthdate: ").append(this.toIndentedString(this.birthdate)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    zoneinfo: ").append(this.toIndentedString(this.zoneinfo)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    picture: ").append(this.toIndentedString(this.picture)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    legalId: ").append(this.toIndentedString(this.legalId)).append("\n");
        sb.append("    userAssets: ").append(this.toIndentedString(this.userAssets)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

