/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.fi691.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.fi691.model.EntitlementType;
import org.springframework.validation.annotation.Validated;

@Validated
@Entity(name="UserAssetType")
public class UserAssetType
extends BaseRootEntity {
    @JsonProperty(value="entityType")
    private EntityTypeEnum entityType = null;
    @JsonProperty(value="assetType")
    private AssetTypeEnum assetType = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="entitlement")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<EntitlementType> entitlement = new HashSet<EntitlementType>();

    public UserAssetType entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @Schema(description="Type of managed entity (e.g.: product, resource, service, customer, account)")
    @NotNull
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public UserAssetType assetType(AssetTypeEnum assetType) {
        this.assetType = assetType;
        return this;
    }

    @Schema(description="Second level to define the type of managed element for product/service/resource managed entities (e.g.: mobile line subscription, video platform license, mobile equipment, etc). Allows identifying the specific asset within the server referenced. Supported values are implementation and application specific. Other values can be added if those listed are not enough")
    public AssetTypeEnum getAssetType() {
        return this.assetType;
    }

    public void setAssetType(AssetTypeEnum assetType) {
        this.assetType = assetType;
    }

    public UserAssetType id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of referenced entity within the entity/asset pair (customerId, accountId, mobile line number, ...)")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserAssetType role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="Represents the part played by an individual in relation to being granted a set of entitlements for manageable assets (e.g.: owner, user, viewer, ...)")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public UserAssetType entitlement(Set<EntitlementType> entitlement) {
        this.entitlement = entitlement;
        return this;
    }

    public UserAssetType addEntitlementItem(EntitlementType entitlementItem) {
        if (this.entitlement == null) {
            this.entitlement = new HashSet<EntitlementType>();
        }
        this.entitlement.add(entitlementItem);
        return this;
    }

    @Schema(description="information about individual entitlements to define access levels to operate over different functions that can be defined in an asset")
    @Valid
    public Set<EntitlementType> getEntitlement() {
        return this.entitlement;
    }

    public void setEntitlement(Set<EntitlementType> entitlement) {
        this.entitlement = entitlement;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAssetType userAssetType = (UserAssetType)o;
        return Objects.equals((Object)this.entityType, (Object)userAssetType.entityType) && Objects.equals((Object)this.assetType, (Object)userAssetType.assetType) && Objects.equals(this.id, userAssetType.id) && Objects.equals(this.role, userAssetType.role) && Objects.equals(this.entitlement, userAssetType.entitlement);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAssetType {\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    assetType: ").append(this.toIndentedString((Object)this.assetType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    entitlement: ").append(this.toIndentedString(this.entitlement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EntityTypeEnum {
        CUSTOMER("customer"),
        ACCOUNT("account"),
        PRODUCT("product"),
        SERVICE("service"),
        RESOURCE("resource");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityTypeEnum fromValue(String text) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AssetTypeEnum {
        MOBILE("mobile"),
        LANDLINE("landline"),
        IPTV("iptv"),
        BROADBAND("broadband"),
        EMAIL("email"),
        INVOICING("invoicing");

        private String value;

        private AssetTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssetTypeEnum fromValue(String text) {
            for (AssetTypeEnum b : AssetTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

