/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.fi691.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Somebody's national ID")
@Validated
@Entity(name="IdentificationType")
public class IdentificationType
extends BaseRootEntity {
    @JsonProperty(value="identificationId")
    private String identificationId = null;
    @JsonProperty(value="country")
    private String country = null;
    @JsonProperty(value="issuingAuthority")
    private String issuingAuthority = null;
    @JsonProperty(value="issuingDate")
    private OffsetDateTime issuingDate = null;

    public IdentificationType identificationId(String identificationId) {
        this.identificationId = identificationId;
        return this;
    }

    @Schema(description="Identification number of the document")
    @NotNull
    public String getIdentificationId() {
        return this.identificationId;
    }

    public void setIdentificationId(String identificationId) {
        this.identificationId = identificationId;
    }

    public IdentificationType country(String country) {
        this.country = country;
        return this;
    }

    @Schema(description="Country that issued the document")
    @NotNull
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public IdentificationType issuingAuthority(String issuingAuthority) {
        this.issuingAuthority = issuingAuthority;
        return this;
    }

    @Schema(description="Authority that issued the legal identification (e.g.: social security, town hall, ...)")
    public String getIssuingAuthority() {
        return this.issuingAuthority;
    }

    public void setIssuingAuthority(String issuingAuthority) {
        this.issuingAuthority = issuingAuthority;
    }

    public IdentificationType issuingDate(OffsetDateTime issuingDate) {
        this.issuingDate = issuingDate;
        return this;
    }

    @Schema(description="Date when identification was issued")
    @Valid
    public OffsetDateTime getIssuingDate() {
        return this.issuingDate;
    }

    public void setIssuingDate(OffsetDateTime issuingDate) {
        this.issuingDate = issuingDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentificationType identificationType = (IdentificationType)o;
        return Objects.equals(this.type, identificationType.type) && Objects.equals(this.identificationId, identificationType.identificationId) && Objects.equals(this.country, identificationType.country) && Objects.equals(this.issuingAuthority, identificationType.issuingAuthority) && Objects.equals(this.issuingDate, identificationType.issuingDate) && Objects.equals(this.schemaLocation, identificationType.schemaLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentificationType {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    identificationId: ").append(this.toIndentedString(this.identificationId)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    issuingAuthority: ").append(this.toIndentedString(this.issuingAuthority)).append("\n");
        sb.append("    issuingDate: ").append(this.toIndentedString(this.issuingDate)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

