/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.fi691.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Validated
@Entity(name="GeographicSubAddressType")
public class GeographicSubAddressType
extends BaseRootNamedEntity {
    @JsonProperty(value="subUnitType")
    private String subUnitType = null;
    @JsonProperty(value="subUnitNumber")
    private String subUnitNumber = null;
    @JsonProperty(value="levelType")
    private String levelType = null;
    @JsonProperty(value="levelNumber")
    private String levelNumber = null;
    @JsonProperty(value="buildingName")
    private String buildingName = null;
    @JsonProperty(value="privateStreetName")
    private String privateStreetName = null;
    @JsonProperty(value="privateStreetNumber")
    private String privateStreetNumber = null;

    public GeographicSubAddressType subUnitType(String subUnitType) {
        this.subUnitType = subUnitType;
        return this;
    }

    @Schema(description="the type of subunit (e.g.: BERTH, FLAT, PIER, SUITE, SHOP, TOWER, UNIT, WHARF)")
    public String getSubUnitType() {
        return this.subUnitType;
    }

    public void setSubUnitType(String subUnitType) {
        this.subUnitType = subUnitType;
    }

    public GeographicSubAddressType subUnitNumber(String subUnitNumber) {
        this.subUnitNumber = subUnitNumber;
        return this;
    }

    @Schema(description="the discriminator used for the subunit often just a simple number (e.g.: 5 for FLAT 5), may also be a range")
    public String getSubUnitNumber() {
        return this.subUnitNumber;
    }

    public void setSubUnitNumber(String subUnitNumber) {
        this.subUnitNumber = subUnitNumber;
    }

    public GeographicSubAddressType levelType(String levelType) {
        this.levelType = levelType;
        return this;
    }

    @Schema(description="Describes level types within a building (e.g.: BASEMENT) ")
    public String getLevelType() {
        return this.levelType;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public GeographicSubAddressType levelNumber(String levelNumber) {
        this.levelNumber = levelNumber;
        return this;
    }

    @Schema(description="used where a level type may be repeated (e.g.: BASEMENT 1, BASEMENT 2)")
    public String getLevelNumber() {
        return this.levelNumber;
    }

    public void setLevelNumber(String levelNumber) {
        this.levelNumber = levelNumber;
    }

    public GeographicSubAddressType buildingName(String buildingName) {
        this.buildingName = buildingName;
        return this;
    }

    @Schema(description="Allows for buildings that have well-known names")
    public String getBuildingName() {
        return this.buildingName;
    }

    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    public GeographicSubAddressType privateStreetName(String privateStreetName) {
        this.privateStreetName = privateStreetName;
        return this;
    }

    @Schema(description="private streets internal to a property (e.g. a university) may have internal names that are not recorded by the land title office")
    public String getPrivateStreetName() {
        return this.privateStreetName;
    }

    public void setPrivateStreetName(String privateStreetName) {
        this.privateStreetName = privateStreetName;
    }

    public GeographicSubAddressType privateStreetNumber(String privateStreetNumber) {
        this.privateStreetNumber = privateStreetNumber;
        return this;
    }

    @Schema(description="Private streets numbers internal to a private street")
    public String getPrivateStreetNumber() {
        return this.privateStreetNumber;
    }

    public void setPrivateStreetNumber(String privateStreetNumber) {
        this.privateStreetNumber = privateStreetNumber;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeographicSubAddressType geographicSubAddressType = (GeographicSubAddressType)o;
        return Objects.equals(this.type, geographicSubAddressType.type) && Objects.equals(this.name, geographicSubAddressType.name) && Objects.equals(this.subUnitType, geographicSubAddressType.subUnitType) && Objects.equals(this.subUnitNumber, geographicSubAddressType.subUnitNumber) && Objects.equals(this.levelType, geographicSubAddressType.levelType) && Objects.equals(this.levelNumber, geographicSubAddressType.levelNumber) && Objects.equals(this.buildingName, geographicSubAddressType.buildingName) && Objects.equals(this.privateStreetName, geographicSubAddressType.privateStreetName) && Objects.equals(this.privateStreetNumber, geographicSubAddressType.privateStreetNumber) && Objects.equals(this.type, geographicSubAddressType.type) && Objects.equals(this.schemaLocation, geographicSubAddressType.schemaLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeographicSubAddressType {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    subUnitType: ").append(this.toIndentedString(this.subUnitType)).append("\n");
        sb.append("    subUnitNumber: ").append(this.toIndentedString(this.subUnitNumber)).append("\n");
        sb.append("    levelType: ").append(this.toIndentedString(this.levelType)).append("\n");
        sb.append("    levelNumber: ").append(this.toIndentedString(this.levelNumber)).append("\n");
        sb.append("    buildingName: ").append(this.toIndentedString(this.buildingName)).append("\n");
        sb.append("    privateStreetName: ").append(this.toIndentedString(this.privateStreetName)).append("\n");
        sb.append("    privateStreetNumber: ").append(this.toIndentedString(this.privateStreetNumber)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

