/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.fi691.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.fi691.model.GeographicLocationRefOrValueType;
import org.etsi.osl.tmf.fi691.model.GeographicSubAddressType;
import org.springframework.validation.annotation.Validated;

@Validated
@Entity(name="GeographicAddressType")
public class GeographicAddressType
extends BaseRootEntity {
    @JsonProperty(value="streetNr")
    private String streetNr = null;
    @JsonProperty(value="streetNrSuffix")
    private String streetNrSuffix = null;
    @JsonProperty(value="streetNrLast")
    private String streetNrLast = null;
    @JsonProperty(value="streetNrLastSuffix")
    private String streetNrLastSuffix = null;
    @JsonProperty(value="streetName")
    private String streetName = null;
    @JsonProperty(value="streetType")
    private String streetType = null;
    @JsonProperty(value="streetSuffix")
    private String streetSuffix = null;
    @JsonProperty(value="postcode")
    private String postcode = null;
    @JsonProperty(value="locality")
    private String locality = null;
    @JsonProperty(value="city")
    private String city = null;
    @JsonProperty(value="stateOrProvince")
    private String stateOrProvince = null;
    @JsonProperty(value="country")
    private String country = null;
    @JsonProperty(value="geographicLocation")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(referencedColumnName="uuid")
    private GeographicLocationRefOrValueType geographicLocation = null;
    @JsonProperty(value="geographicSubAddress")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(referencedColumnName="uuid")
    private GeographicSubAddressType geographicSubAddress = null;

    public GeographicAddressType streetNr(String streetNr) {
        this.streetNr = streetNr;
        return this;
    }

    @Schema(description="Required if href not included. Number identifying a specific property on a public street. It may be combined with streetNrLast for ranged addresses")
    @NotNull
    public String getStreetNr() {
        return this.streetNr;
    }

    public void setStreetNr(String streetNr) {
        this.streetNr = streetNr;
    }

    public GeographicAddressType streetNrSuffix(String streetNrSuffix) {
        this.streetNrSuffix = streetNrSuffix;
        return this;
    }

    @Schema(description="The street number suffix (or suffix of first number for  aranged address)")
    public String getStreetNrSuffix() {
        return this.streetNrSuffix;
    }

    public void setStreetNrSuffix(String streetNrSuffix) {
        this.streetNrSuffix = streetNrSuffix;
    }

    public GeographicAddressType streetNrLast(String streetNrLast) {
        this.streetNrLast = streetNrLast;
        return this;
    }

    @Schema(description="Last number in a range of street numbers allocated to a property")
    public String getStreetNrLast() {
        return this.streetNrLast;
    }

    public void setStreetNrLast(String streetNrLast) {
        this.streetNrLast = streetNrLast;
    }

    public GeographicAddressType streetNrLastSuffix(String streetNrLastSuffix) {
        this.streetNrLastSuffix = streetNrLastSuffix;
        return this;
    }

    @Schema(description="Last street number suffix for a ranged address")
    public String getStreetNrLastSuffix() {
        return this.streetNrLastSuffix;
    }

    public void setStreetNrLastSuffix(String streetNrLastSuffix) {
        this.streetNrLastSuffix = streetNrLastSuffix;
    }

    public GeographicAddressType streetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    @Schema(description="Required if href not included. Name of the street or other street type")
    @NotNull
    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public GeographicAddressType streetType(String streetType) {
        this.streetType = streetType;
        return this;
    }

    @Schema(description="Required if href not included. Alley, avenue, street, boulevard, brae, crescent, drive, highway, lane, terrace, parade, place, tarn, way, wharf")
    @NotNull
    public String getStreetType() {
        return this.streetType;
    }

    public void setStreetType(String streetType) {
        this.streetType = streetType;
    }

    public GeographicAddressType streetSuffix(String streetSuffix) {
        this.streetSuffix = streetSuffix;
        return this;
    }

    @Schema(description="A modifier denoting a relative direction (E, W, S, N)")
    public String getStreetSuffix() {
        return this.streetSuffix;
    }

    public void setStreetSuffix(String streetSuffix) {
        this.streetSuffix = streetSuffix;
    }

    public GeographicAddressType postcode(String postcode) {
        this.postcode = postcode;
        return this;
    }

    @Schema(description="Required if href not included. Descriptor for a postal delivery area (also known as zipcode)")
    @NotNull
    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public GeographicAddressType locality(String locality) {
        this.locality = locality;
        return this;
    }

    @Schema(description="Required if href not included. An area of defined or undefined boundaries within a local authority or other legislatively defined area, usually rural or semi-rural in nature, or a suburb, a bounded locality within a city, town or shire principally of urban character ")
    @NotNull
    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public GeographicAddressType city(String city) {
        this.city = city;
        return this;
    }

    @Schema(description="City that the address is in")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public GeographicAddressType stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @Schema(description="Required if href not included. the State or Province that the address is in")
    @NotNull
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public GeographicAddressType country(String country) {
        this.country = country;
        return this;
    }

    @Schema(description="Required if href not included. Country that the address is in")
    @NotNull
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public GeographicAddressType geographicLocation(GeographicLocationRefOrValueType geographicLocation) {
        this.geographicLocation = geographicLocation;
        return this;
    }

    @Schema(description="A geo location reference, allows describing through coordinate(s) a point, a line or a space")
    @Valid
    public GeographicLocationRefOrValueType getGeographicLocation() {
        return this.geographicLocation;
    }

    public void setGeographicLocation(GeographicLocationRefOrValueType geographicLocation) {
        this.geographicLocation = geographicLocation;
    }

    public GeographicAddressType geographicSubAddress(GeographicSubAddressType geographicSubAddress) {
        this.geographicSubAddress = geographicSubAddress;
        return this;
    }

    @Schema(description="A list of sub addresses. It is used for addressing within a property in an urban area (country properties are often defined differently). It may refer to a building, a building cluster, or a floor of a multistory building.")
    @Valid
    public GeographicSubAddressType getGeographicSubAddress() {
        return this.geographicSubAddress;
    }

    public void setGeographicSubAddress(GeographicSubAddressType geographicSubAddress) {
        this.geographicSubAddress = geographicSubAddress;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeographicAddressType geographicAddressType = (GeographicAddressType)o;
        return Objects.equals(this.streetNr, geographicAddressType.streetNr) && Objects.equals(this.streetNrSuffix, geographicAddressType.streetNrSuffix) && Objects.equals(this.streetNrLast, geographicAddressType.streetNrLast) && Objects.equals(this.streetNrLastSuffix, geographicAddressType.streetNrLastSuffix) && Objects.equals(this.streetName, geographicAddressType.streetName) && Objects.equals(this.streetType, geographicAddressType.streetType) && Objects.equals(this.streetSuffix, geographicAddressType.streetSuffix) && Objects.equals(this.postcode, geographicAddressType.postcode) && Objects.equals(this.locality, geographicAddressType.locality) && Objects.equals(this.city, geographicAddressType.city) && Objects.equals(this.stateOrProvince, geographicAddressType.stateOrProvince) && Objects.equals(this.country, geographicAddressType.country) && Objects.equals(this.geographicLocation, geographicAddressType.geographicLocation) && Objects.equals(this.geographicSubAddress, geographicAddressType.geographicSubAddress) && Objects.equals(this.type, geographicAddressType.type) && Objects.equals(this.schemaLocation, geographicAddressType.schemaLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeographicAddressType {\n");
        sb.append("    streetNr: ").append(this.toIndentedString(this.streetNr)).append("\n");
        sb.append("    streetNrSuffix: ").append(this.toIndentedString(this.streetNrSuffix)).append("\n");
        sb.append("    streetNrLast: ").append(this.toIndentedString(this.streetNrLast)).append("\n");
        sb.append("    streetNrLastSuffix: ").append(this.toIndentedString(this.streetNrLastSuffix)).append("\n");
        sb.append("    streetName: ").append(this.toIndentedString(this.streetName)).append("\n");
        sb.append("    streetType: ").append(this.toIndentedString(this.streetType)).append("\n");
        sb.append("    streetSuffix: ").append(this.toIndentedString(this.streetSuffix)).append("\n");
        sb.append("    postcode: ").append(this.toIndentedString(this.postcode)).append("\n");
        sb.append("    locality: ").append(this.toIndentedString(this.locality)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    geographicLocation: ").append(this.toIndentedString(this.geographicLocation)).append("\n");
        sb.append("    geographicSubAddress: ").append(this.toIndentedString(this.geographicSubAddress)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

