/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="The reference object to the schema and type of target service which is described by service specification")
@Validated
public class TargetServiceSchema {
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public TargetServiceSchema baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public TargetServiceSchema schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="This field provides a link to the schema describing the target service")
    @NotNull
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public TargetServiceSchema type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="Class type of the target service")
    @NotNull
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetServiceSchema targetServiceSchema = (TargetServiceSchema)o;
        return Objects.equals(this.baseType, targetServiceSchema.baseType) && Objects.equals(this.schemaLocation, targetServiceSchema.schemaLocation) && Objects.equals(this.type, targetServiceSchema.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TargetServiceSchema {\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

