/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.scm633.model.TargetServiceSchema;
import org.springframework.validation.annotation.Validated;

@Schema(description="Service specification reference: ServiceSpecification(s) required to realize a ProductSpecification.")
@Validated
@Entity(name="ServiceSpecificationRef")
@JsonIgnoreProperties(value={"uuid"})
public class ServiceSpecificationRef
extends BaseRootNamedEntity {
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="targetServiceSchema")
    private TargetServiceSchema targetServiceSchema = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;
    @JsonProperty(value="id")
    protected String id = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceSpecificationRef version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Service specification version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceSpecificationRef targetServiceSchema(TargetServiceSchema targetServiceSchema) {
        this.targetServiceSchema = targetServiceSchema;
        return this;
    }

    @Schema(description="A target service schema reference (TargetServiceSchemaRef). The reference object to the schema and type of target service which is described by service specification.")
    @Valid
    public TargetServiceSchema getTargetServiceSchema() {
        return this.targetServiceSchema;
    }

    public void setTargetServiceSchema(TargetServiceSchema targetServiceSchema) {
        this.targetServiceSchema = targetServiceSchema;
    }

    public ServiceSpecificationRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecificationRef serviceSpecificationRef = (ServiceSpecificationRef)o;
        return Objects.equals(this.id, serviceSpecificationRef.id) && Objects.equals(this.href, serviceSpecificationRef.href) && Objects.equals(this.name, serviceSpecificationRef.name) && Objects.equals(this.version, serviceSpecificationRef.version) && Objects.equals(this.targetServiceSchema, serviceSpecificationRef.targetServiceSchema) && Objects.equals(this.baseType, serviceSpecificationRef.baseType) && Objects.equals(this.schemaLocation, serviceSpecificationRef.schemaLocation) && Objects.equals(this.type, serviceSpecificationRef.type) && Objects.equals(this.referredType, serviceSpecificationRef.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceSpecificationRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    targetServiceSchema: ").append(this.toIndentedString(this.targetServiceSchema)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

