/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Describes links with services of the same category (useful for bundled services)")
@Validated
@Entity(name="ServiceRelationship")
public class ServiceRelationship
extends BaseRootEntity {
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="service_serviceref_uuid", referencedColumnName="uuid")
    @JsonProperty(value="service")
    private ServiceRef service = null;

    public ServiceRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="The type of relationship (e.g. depends on, enables)")
    @NotNull
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public ServiceRelationship service(ServiceRef service) {
        this.service = service;
        return this;
    }

    @Schema(description="The service being referred to")
    @NotNull
    @Valid
    public ServiceRef getService() {
        return this.service;
    }

    public void setService(ServiceRef service) {
        this.service = service;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceRelationship serviceRelationship = (ServiceRelationship)o;
        return Objects.equals(this.relationshipType, serviceRelationship.relationshipType) && Objects.equals(this.service, serviceRelationship.service) && Objects.equals(this.baseType, serviceRelationship.baseType) && Objects.equals(this.schemaLocation, serviceRelationship.schemaLocation) && Objects.equals(this.type, serviceRelationship.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceRelationship {\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

