/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Extra information about a given entity")
@Validated
@Entity(name="Note")
public class Note
extends BaseRootEntity {
    @JsonProperty(value="author")
    private String author = null;
    private OffsetDateTime date = null;
    @JsonProperty(value="system")
    private String system = null;
    @Lob
    @Column(name="LTEXT", columnDefinition="LONGTEXT")
    @JsonProperty(value="text")
    private String text = null;

    public Note author(String author) {
        this.author = author;
        return this;
    }

    @Schema(description="Author of the note")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Note date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Schema(description="Date of the note")
    @Valid
    @JsonProperty(value="date")
    public String getDateString() {
        if (this.date == null) {
            return null;
        }
        return this.date.toString();
    }

    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(String adate) {
        if (adate != null) {
            this.date = OffsetDateTime.parse(adate);
        }
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public Note system(String system) {
        this.system = system;
        return this;
    }

    @Schema(description="Describes the system from which the action related to this note was done")
    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public Note text(String text) {
        this.text = text;
        if (this.date == null) {
            this.setDate(OffsetDateTime.now(ZoneOffset.UTC).toString());
        }
        return this;
    }

    @Schema(description="Text of the note")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.setDate(OffsetDateTime.now(ZoneOffset.UTC).toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        return Objects.equals(this.author, note.author) && Objects.equals(this.date, note.date) && Objects.equals(this.system, note.system) && Objects.equals(this.text, note.text) && Objects.equals(this.baseType, note.baseType) && Objects.equals(this.schemaLocation, note.schemaLocation) && Objects.equals(this.type, note.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Note {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

