/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Describes a given characteristic of an object or entity through a name/value pair.")
@Validated
@Entity(name="ServiceRestrictionCharacteristic")
public class Characteristic
extends BaseRootNamedEntity {
    @JsonProperty(value="valueType")
    private String valueType = null;
    private Any value = null;

    public Characteristic valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="Data type of the value of the characteristic")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public Characteristic value(Any value) {
        this.value = value;
        return this;
    }

    @Schema(description="The value of the characteristic")
    @NotNull
    @Valid
    @JsonProperty(value="value")
    public Object getValueAsString() {
        if (this.value != null && this.valueType != null && this.valueType.equalsIgnoreCase("string") && (this.value.getAlias() == null || this.value.getAlias().equals(""))) {
            return this.value.getValue();
        }
        return this.value;
    }

    public Any getValue() {
        return this.value;
    }

    public void setValue(Any value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Characteristic characteristic = (Characteristic)o;
        return Objects.equals(this.name, characteristic.name) && Objects.equals(this.valueType, characteristic.valueType) && Objects.equals(this.value, characteristic.value) && Objects.equals(this.baseType, characteristic.baseType) && Objects.equals(this.schemaLocation, characteristic.schemaLocation) && Objects.equals(this.type, characteristic.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Characteristic {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

