/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Embeddable;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="A period of time, either as a deadline (endDateTime only) a startDateTime only, or both")
@Validated
@Embeddable
public class TimePeriod {
    private OffsetDateTime endDateTime = null;
    private OffsetDateTime startDateTime = null;

    public TimePeriod() {
        this.setStartDateTime(OffsetDateTime.now(ZoneOffset.UTC));
        this.setEndDateTime(OffsetDateTime.now(ZoneOffset.UTC).plusYears(20L));
    }

    public TimePeriod(TimePeriod src) {
        this();
        if (src != null) {
            this.setStartDateTime(src.getStartDateTime());
            this.setEndDateTime(src.getEndDateTime());
        }
    }

    public TimePeriod endDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @Schema(description="End of the time period, using IETC-RFC-3339 format")
    @Valid
    @JsonProperty(value="endDateTime")
    public String getEndDateTimeString() {
        return this.endDateTime.toString();
    }

    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public TimePeriod startDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public void setEndDateTime(String endDateTime) {
        this.endDateTime = OffsetDateTime.parse(endDateTime);
    }

    @Schema(description="Start of the time period, using IETC-RFC-3339 format. If you define a start, you must also define an end")
    @Valid
    @JsonProperty(value="startDateTime")
    public String getStartDateTimeString() {
        return this.startDateTime.toString();
    }

    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public void setStartDateTime(String startDateTime) {
        if (startDateTime != null) {
            this.startDateTime = OffsetDateTime.parse(startDateTime);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePeriod timePeriod = (TimePeriod)o;
        return Objects.equals(this.endDateTime, timePeriod.endDateTime) && Objects.equals(this.startDateTime, timePeriod.startDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.endDateTime, this.startDateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimePeriod {\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void copyFromObj(TimePeriod validFor) {
        if (validFor != null) {
            this.startDateTime = validFor.startDateTime;
            this.endDateTime = validFor.endDateTime;
        }
    }
}

