/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Embeddable;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="An amount in a given unit")
@Validated
@Embeddable
public class Quantity {
    @JsonProperty(value="amount")
    private Float amount = Float.valueOf(1.0f);
    @JsonProperty(value="units")
    private String units = null;

    public Quantity amount(Float amount) {
        this.amount = amount;
        return this;
    }

    @Schema(description="Numeric value in a given unit")
    public Float getAmount() {
        return this.amount;
    }

    public void setAmount(Float amount) {
        this.amount = amount;
    }

    public Quantity units(String units) {
        this.units = units;
        return this;
    }

    @Schema(description="Unit")
    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quantity quantity = (Quantity)o;
        return Objects.equals(this.amount, quantity.amount) && Objects.equals(this.units, quantity.units);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.units);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Quantity {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    units: ").append(this.toIndentedString(this.units)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

