/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.UUID;
import org.springframework.validation.annotation.Validated;

@Schema(description="The notification data structure")
@Validated
public class OpensliceEvent {
    @JsonProperty(value="id")
    protected String id = UUID.randomUUID().toString();
    @JsonProperty(value="href")
    protected String href = null;
    @JsonProperty(value="eventId")
    protected String eventId = UUID.randomUUID().toString();
    protected OffsetDateTime eventTime = OffsetDateTime.now(ZoneOffset.UTC);
    @JsonProperty(value="eventType")
    protected String eventType = null;
    @JsonProperty(value="correlationId")
    protected String correlationId = null;
    @JsonProperty(value="domain")
    protected String domain = null;
    @JsonProperty(value="title")
    protected String title = null;
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="priority")
    protected String priority = null;
    protected OffsetDateTime timeOcurred = null;

    public OpensliceEvent id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Identifier of the Process flow")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OpensliceEvent href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of the ProcessFlow")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public OpensliceEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(description="The identifier of the notification.")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public OpensliceEvent eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Schema(description="Time of the event occurrence.")
    @Valid
    @JsonProperty(value="eventTime")
    public String getEventTimeString() {
        return this.eventTime.toString();
    }

    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public void setEventTime(String eventTime) {
        if (eventTime != null) {
            this.eventTime = OffsetDateTime.parse(eventTime);
        }
    }

    public OpensliceEvent eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(description="The type of the notification.")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public OpensliceEvent correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Schema(description="The correlation id for this event.")
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public OpensliceEvent domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(description="The domain of the event.")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public OpensliceEvent title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The title of the event.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public OpensliceEvent description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="An explnatory of the event.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OpensliceEvent priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A priority.")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public OpensliceEvent timeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
        return this;
    }

    @Schema(description="The time the event occured.")
    @Valid
    @JsonProperty(value="timeOcurred")
    public String getTimeOcurredString() {
        return this.timeOcurred.toString();
    }

    public OffsetDateTime getTimeOcurred() {
        return this.timeOcurred;
    }

    public void setTimeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
    }

    public void setTimeOcurred(String timeOcurred) {
        if (timeOcurred != null) {
            this.timeOcurred = OffsetDateTime.parse(timeOcurred);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpensliceEvent alarmCreateEvent = (OpensliceEvent)o;
        return Objects.equals(this.id, alarmCreateEvent.id) && Objects.equals(this.href, alarmCreateEvent.href) && Objects.equals(this.eventId, alarmCreateEvent.eventId) && Objects.equals(this.eventTime, alarmCreateEvent.eventTime) && Objects.equals(this.eventType, alarmCreateEvent.eventType) && Objects.equals(this.correlationId, alarmCreateEvent.correlationId) && Objects.equals(this.domain, alarmCreateEvent.domain) && Objects.equals(this.title, alarmCreateEvent.title) && Objects.equals(this.description, alarmCreateEvent.description) && Objects.equals(this.priority, alarmCreateEvent.priority) && Objects.equals(this.timeOcurred, alarmCreateEvent.timeOcurred);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlarmCreateEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    timeOcurred: ").append(this.toIndentedString(this.timeOcurred)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

