/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.UUID;
import org.springframework.validation.annotation.Validated;

@Schema(description="The notification data structure")
@Validated
public class Notification {
    @JsonProperty(value="eventId")
    protected String eventId = UUID.randomUUID().toString();
    protected OffsetDateTime eventTime = OffsetDateTime.now(ZoneOffset.UTC);
    @JsonProperty(value="eventType")
    protected String eventType = null;
    @JsonProperty(value="fieldPath")
    protected String fieldPath = null;
    @JsonProperty(value="resourcePath")
    protected String resourcePath = null;

    public Notification eventId() {
        return this;
    }

    public Notification eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(description="The identifier of the notification")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public Notification eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Schema(description="Time of the event occurrence")
    @Valid
    @JsonProperty(value="eventTime")
    public String getEventTimeString() {
        return this.eventTime.toString();
    }

    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public void setEventTime(String eventTime) {
        if (eventTime != null) {
            this.eventTime = OffsetDateTime.parse(eventTime);
        }
    }

    public Notification eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(description="The type of the notification")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Notification fieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return this;
    }

    @Schema(description="The path identifying the object field concerned by this notification")
    public String getFieldPath() {
        return this.fieldPath;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    public Notification resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    @Schema(description="The path identifying the resource object concerned by this notification")
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification serviceOrderCreateNotification = (Notification)o;
        return Objects.equals(this.eventId, serviceOrderCreateNotification.eventId) && Objects.equals(this.eventTime, serviceOrderCreateNotification.eventTime) && Objects.equals(this.eventType, serviceOrderCreateNotification.eventType) && Objects.equals(this.fieldPath, serviceOrderCreateNotification.fieldPath) && Objects.equals(this.resourcePath, serviceOrderCreateNotification.resourcePath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceOrderCreateNotification {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    fieldPath: ").append(this.toIndentedString(this.fieldPath)).append("\n");
        sb.append("    resourcePath: ").append(this.toIndentedString(this.resourcePath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

