/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Objects;

@Schema(name="Error", description="Used when an API throws an Error, typically with a HTTP error response-code (3xx, 4xx, 5xx)")
public class Error {
    private String code;
    private String reason;
    private String message;
    private String status;
    private URI referenceError;
    private String atBaseType;
    private URI atSchemaLocation;
    private String atType;

    public Error() {
    }

    public Error(String code, String reason) {
        this.code = code;
        this.reason = reason;
    }

    public Error code(String code) {
        this.code = code;
        return this;
    }

    @NotNull
    @Schema(name="code", description="Application relevant detail, defined in the API or a common list.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Error reason(String reason) {
        this.reason = reason;
        return this;
    }

    @NotNull
    @Schema(name="reason", description="Explanation of the reason for the error which can be shown to a client user.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Error message(String message) {
        this.message = message;
        return this;
    }

    @Schema(name="message", description="More details and corrective actions related to the error which can be shown to a client user.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error status(String status) {
        this.status = status;
        return this;
    }

    @Schema(name="status", description="HTTP Error code extension", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Error referenceError(URI referenceError) {
        this.referenceError = referenceError;
        return this;
    }

    @Valid
    @Schema(name="referenceError", description="URI of documentation describing the error.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="referenceError")
    public URI getReferenceError() {
        return this.referenceError;
    }

    public void setReferenceError(URI referenceError) {
        this.referenceError = referenceError;
    }

    public Error atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@baseType")
    public String getAtBaseType() {
        return this.atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public Error atSchemaLocation(URI atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    @Valid
    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@schemaLocation")
    public URI getAtSchemaLocation() {
        return this.atSchemaLocation;
    }

    public void setAtSchemaLocation(URI atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public Error atType(String atType) {
        this.atType = atType;
        return this;
    }

    @Schema(name="@type", description="When sub-classing, this defines the sub-class entity name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@type")
    public String getAtType() {
        return this.atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.code, error.code) && Objects.equals(this.reason, error.reason) && Objects.equals(this.message, error.message) && Objects.equals(this.status, error.status) && Objects.equals(this.referenceError, error.referenceError) && Objects.equals(this.atBaseType, error.atBaseType) && Objects.equals(this.atSchemaLocation, error.atSchemaLocation) && Objects.equals(this.atType, error.atType);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.reason, this.message, this.status, this.referenceError, this.atBaseType, this.atSchemaLocation, this.atType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    referenceError: ").append(this.toIndentedString(this.referenceError)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.atSchemaLocation)).append("\n");
        sb.append("    atType: ").append(this.toIndentedString(this.atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

