/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Objects;

@Schema(name="EntityRef", description="Entity reference schema to be use for all entityRef class.")
public class EntityRef {
    private String id;
    private URI href;
    private String name;
    private String atBaseType;
    private URI atSchemaLocation;
    private String atType;
    private String atReferredType;

    public EntityRef() {
    }

    public EntityRef(String id) {
        this.id = id;
    }

    public EntityRef id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="unique identifier", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EntityRef href(URI href) {
        this.href = href;
        return this;
    }

    @Valid
    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    public void setHref(URI href) {
        this.href = href;
    }

    public EntityRef name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Name of the related entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntityRef atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@baseType")
    public String getAtBaseType() {
        return this.atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public EntityRef atSchemaLocation(URI atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    @Valid
    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@schemaLocation")
    public URI getAtSchemaLocation() {
        return this.atSchemaLocation;
    }

    public void setAtSchemaLocation(URI atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public EntityRef atType(String atType) {
        this.atType = atType;
        return this;
    }

    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@type")
    public String getAtType() {
        return this.atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public EntityRef atReferredType(String atReferredType) {
        this.atReferredType = atReferredType;
        return this;
    }

    @Schema(name="@referredType", description="The actual type of the target instance when needed for disambiguation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@referredType")
    public String getAtReferredType() {
        return this.atReferredType;
    }

    public void setAtReferredType(String atReferredType) {
        this.atReferredType = atReferredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityRef entityRef = (EntityRef)o;
        return Objects.equals(this.id, entityRef.id) && Objects.equals(this.href, entityRef.href) && Objects.equals(this.name, entityRef.name) && Objects.equals(this.atBaseType, entityRef.atBaseType) && Objects.equals(this.atSchemaLocation, entityRef.atSchemaLocation) && Objects.equals(this.atType, entityRef.atType) && Objects.equals(this.atReferredType, entityRef.atReferredType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.name, this.atBaseType, this.atSchemaLocation, this.atType, this.atReferredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.atSchemaLocation)).append("\n");
        sb.append("    atType: ").append(this.toIndentedString(this.atType)).append("\n");
        sb.append("    atReferredType: ").append(this.toIndentedString(this.atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

