/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.net.URI;
import java.util.Objects;

@Schema(name="Entity", description="Base entity schema for use in TMForum Open-APIs")
public class Entity {
    private String id;
    private URI href;
    private String atBaseType;
    private URI atSchemaLocation;
    private String atType;

    public Entity id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Entity href(URI href) {
        this.href = href;
        return this;
    }

    @Valid
    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    public void setHref(URI href) {
        this.href = href;
    }

    public Entity atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@baseType")
    public String getAtBaseType() {
        return this.atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public Entity atSchemaLocation(URI atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    @Valid
    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@schemaLocation")
    public URI getAtSchemaLocation() {
        return this.atSchemaLocation;
    }

    public void setAtSchemaLocation(URI atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public Entity atType(String atType) {
        this.atType = atType;
        return this;
    }

    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@type")
    public String getAtType() {
        return this.atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return Objects.equals(this.id, entity.id) && Objects.equals(this.href, entity.href) && Objects.equals(this.atBaseType, entity.atBaseType) && Objects.equals(this.atSchemaLocation, entity.atSchemaLocation) && Objects.equals(this.atType, entity.atType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.atBaseType, this.atSchemaLocation, this.atType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Entity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.atSchemaLocation)).append("\n");
        sb.append("    atType: ").append(this.toIndentedString(this.atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

