/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Lob;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.ELifecycle;
import org.etsi.osl.tmf.common.model.TimePeriod;

@Entity(name="BaseEntity")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class BaseEntity
extends BaseRootNamedEntity {
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    protected String description = null;
    protected OffsetDateTime lastUpdate = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = ELifecycle.IN_STUDY.getValue();
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;

    public BaseEntity() {
        this.baseType = "BaseRootEntity";
        this.type = "BaseEntity";
    }

    public BaseEntity description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of this catalog")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BaseEntity lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update")
    @Valid
    @JsonProperty(value="lastUpdate")
    public String getLastUpdateString() {
        if (this.lastUpdate != null) {
            return this.lastUpdate.toString();
        }
        return null;
    }

    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate != null ? OffsetDateTime.parse(lastUpdate) : OffsetDateTime.now();
    }

    public BaseEntity lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public void setLifecycleStatusEnum(ELifecycle alifecycleStatus) {
        this.lifecycleStatus = alifecycleStatus.getValue();
    }

    public BaseEntity version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Entity version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Schema(description="The period for which the entity is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEntity Entity2 = (BaseEntity)o;
        return Objects.equals(this.uuid, Entity2.uuid) && Objects.equals(this.href, Entity2.href) && Objects.equals(this.description, Entity2.description) && Objects.equals(this.lastUpdate, Entity2.lastUpdate) && Objects.equals(this.lifecycleStatus, Entity2.lifecycleStatus) && Objects.equals(this.name, Entity2.name) && Objects.equals(this.version, Entity2.version) && Objects.equals(this.validFor, Entity2.validFor) && Objects.equals(this.baseType, Entity2.baseType) && Objects.equals(this.schemaLocation, Entity2.schemaLocation) && Objects.equals(this.type, Entity2.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uuid, this.href, this.description, this.lastUpdate, this.lifecycleStatus, this.name, this.version, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Entity {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public void copyFromObj(BaseEntity be) {
        super.copyFromObj(be);
        this.description = be.description;
        this.lastUpdate = be.lastUpdate;
        this.lifecycleStatus = be.lifecycleStatus;
        this.version = be.version;
        if (this.validFor != null) {
            this.validFor.copyFromObj(be.validFor);
        }
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

