/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.Quantity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="An attachment by value or by reference. An attachment complements the description of an element, for example through a document, a video, a picture.")
@Validated
@Entity(name="AttachmentRefOrValue")
@Table(name="AttachmentRefOrValue")
public class AttachmentRefOrValue
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="attachmentType")
    private String attachmentType = null;
    @JsonProperty(value="content")
    private String content = null;
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="mimeType")
    private String mimeType = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="size")
    private Quantity size = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;

    @Schema(example="4aafacbd-11ff-4dc8-b445-305f2215715f", description="Unique identifier for this particular attachment")
    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AttachmentRefOrValue attachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
        return this;
    }

    @Schema(example="video", description="Attachment type such as video, picture")
    public String getAttachmentType() {
        return this.attachmentType;
    }

    public void setAttachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
    }

    public AttachmentRefOrValue content(String content) {
        this.content = content;
        return this;
    }

    @Schema(description="The actual contents of the attachment object, if embedded, encoded as base64")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public AttachmentRefOrValue description(String description) {
        this.description = description;
        return this;
    }

    @Schema(example="Photograph of the Product", description="A narrative text describing the content of the attachment")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AttachmentRefOrValue mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Schema(description="Attachment mime type such as extension file for video, picture and document")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public AttachmentRefOrValue url(String url) {
        this.url = url;
        return this;
    }

    @Schema(example="http://host/Content/4aafacbd-11ff-4dc8-b445-305f2215715f", description="Uniform Resource Locator, is a web page address (a subset of URI)")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AttachmentRefOrValue size(Quantity size) {
        this.size = size;
        return this;
    }

    @Schema(description="")
    @Valid
    public Quantity getSize() {
        return this.size;
    }

    public void setSize(Quantity size) {
        this.size = size;
    }

    public AttachmentRefOrValue validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public AttachmentRefOrValue _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentRefOrValue attachmentRefOrValue = (AttachmentRefOrValue)o;
        return Objects.equals(this.id, attachmentRefOrValue.id) && Objects.equals(this.href, attachmentRefOrValue.href) && Objects.equals(this.attachmentType, attachmentRefOrValue.attachmentType) && Objects.equals(this.content, attachmentRefOrValue.content) && Objects.equals(this.description, attachmentRefOrValue.description) && Objects.equals(this.mimeType, attachmentRefOrValue.mimeType) && Objects.equals(this.name, attachmentRefOrValue.name) && Objects.equals(this.url, attachmentRefOrValue.url) && Objects.equals(this.size, attachmentRefOrValue.size) && Objects.equals(this.validFor, attachmentRefOrValue.validFor) && Objects.equals(this.baseType, attachmentRefOrValue.baseType) && Objects.equals(this.schemaLocation, attachmentRefOrValue.schemaLocation) && Objects.equals(this.type, attachmentRefOrValue.type) && Objects.equals(this._atReferredType, attachmentRefOrValue._atReferredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachmentRefOrValue {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    attachmentType: ").append(this.toIndentedString(this.attachmentType)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

