/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Attachment reference. An attachment complements the description of an element (for instance a product) through video, pictures")
@Validated
@Entity(name="AttachmentRef")
public class AttachmentRef
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public AttachmentRef() {
    }

    public AttachmentRef(AttachmentRef src) {
        this.description = src.description;
        this.url = src.url;
        this.id = src.id;
    }

    public AttachmentRef description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative text describing the content of the attachment")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AttachmentRef url(String url) {
        this.url = url;
        return this;
    }

    @Schema(description="Link to the attachment media/content")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AttachmentRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentRef attachmentRef = (AttachmentRef)o;
        return Objects.equals(this.id, attachmentRef.id) && Objects.equals(this.href, attachmentRef.href) && Objects.equals(this.description, attachmentRef.description) && Objects.equals(this.url, attachmentRef.url) && Objects.equals(this.baseType, attachmentRef.baseType) && Objects.equals(this.schemaLocation, attachmentRef.schemaLocation) && Objects.equals(this.type, attachmentRef.type) && Objects.equals(this.referredType, attachmentRef.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachmentRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

