/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.Quantity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Complements the description of an element (for instance a product) through video, pictures...")
@Validated
@Entity(name="Attachment")
public class Attachment
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="attachmentType")
    private String attachmentType = null;
    @Lob
    @Column(name="LCONTENT", columnDefinition="LONGTEXT")
    @JsonProperty(value="content")
    private String content = null;
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="mimeType")
    private String mimeType = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="size")
    private Quantity size = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    @Schema(description="Unique identifier for this particular attachment")
    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public Attachment attachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
        return this;
    }

    @Schema(description="Attachment type such as video, picture")
    public String getAttachmentType() {
        return this.attachmentType;
    }

    public void setAttachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
    }

    public Attachment content(String content) {
        this.content = content;
        return this;
    }

    @Schema(description="The actual contents of the attachment object, if embedded, encoded as base64")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Attachment description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative text describing the content of the attachment")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Attachment mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Schema(description="Attachment mime type such as extension file for video, picture and document")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Attachment url(String url) {
        this.url = url;
        return this;
    }

    @Schema(description="Uniform Resource Locator, is a web page address (a subset of URI)")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Attachment size(Quantity size) {
        this.size = size;
        return this;
    }

    @Schema(description="The size of the attachment.")
    @Valid
    public Quantity getSize() {
        return this.size;
    }

    public void setSize(Quantity size) {
        this.size = size;
    }

    public Attachment validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period of time for which the attachment is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment attachment = (Attachment)o;
        return Objects.equals(this.id, attachment.id) && Objects.equals(this.uuid, attachment.uuid) && Objects.equals(this.href, attachment.href) && Objects.equals(this.attachmentType, attachment.attachmentType) && Objects.equals(this.content, attachment.content) && Objects.equals(this.description, attachment.description) && Objects.equals(this.mimeType, attachment.mimeType) && Objects.equals(this.name, attachment.name) && Objects.equals(this.url, attachment.url) && Objects.equals(this.size, attachment.size) && Objects.equals(this.validFor, attachment.validFor) && Objects.equals(this.baseType, attachment.baseType) && Objects.equals(this.schemaLocation, attachment.schemaLocation) && Objects.equals(this.type, attachment.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uuid, this.id, this.href, this.attachmentType, this.content, this.description, this.mimeType, this.name, this.url, this.size, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attachment {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    attachmentType: ").append(this.toIndentedString(this.attachmentType)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

