/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.common.model;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Lob;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Embeddable
public class Any {
    @Lob
    @Column(columnDefinition="LONGTEXT")
    private String value;
    private String alias;

    public Any() {
    }

    public Any(String value) {
        this.value = value;
    }

    public Any(String value, String alias) {
        this.value = value;
        this.alias = alias;
    }

    public Any(long value, String alias) {
        this.value = "" + value;
        this.alias = alias;
    }

    public Any(int value, String alias) {
        this.value = "" + value;
        this.alias = alias;
    }

    public Any(int value) {
        this.value = "" + value;
        this.alias = "";
    }

    public Any(Any anyval) {
        if (anyval != null) {
            this.value = anyval.value;
            this.alias = anyval.alias;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Any a = (Any)o;
        return Objects.equals(this.value, a.value) && Objects.equals(this.alias, a.alias);
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Any {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

