/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.cm629.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am651.model.AgreementRef;
import org.etsi.osl.tmf.am666.model.AccountRef;
import org.etsi.osl.tmf.am666.model.PaymentMethodRef;
import org.etsi.osl.tmf.cm629.model.CreditProfile;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm632.model.Characteristic;
import org.etsi.osl.tmf.pm632.model.ContactMedium;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description=" Skipped properties: id,href")
@Validated
public class CustomerUpdate {
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="status")
    protected String status = null;
    @JsonProperty(value="statusReason")
    protected String statusReason = null;
    @JsonProperty(value="account")
    @Valid
    protected List<AccountRef> account = null;
    @JsonProperty(value="agreement")
    @Valid
    protected List<AgreementRef> agreement = null;
    @JsonProperty(value="characteristic")
    @Valid
    protected List<Characteristic> characteristic = null;
    @JsonProperty(value="contactMedium")
    @Valid
    protected List<ContactMedium> contactMedium = null;
    @JsonProperty(value="creditProfile")
    @Valid
    protected List<CreditProfile> creditProfile = null;
    @JsonProperty(value="engagedParty")
    protected RelatedParty engagedParty = null;
    @JsonProperty(value="paymentMethod")
    @Valid
    protected List<PaymentMethodRef> paymentMethod = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public CustomerUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A word, term, or phrase by which the Customer is known and distinguished from other Customers.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomerUpdate status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="Used to track the lifecycle status of the customer.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public CustomerUpdate statusReason(String statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    @Schema(description="A string providing an explanation on the value of the status lifecycle. For instance if the status is Rejected, statusReason will provide the reason for rejection.")
    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public CustomerUpdate account(List<AccountRef> account) {
        this.account = account;
        return this;
    }

    public CustomerUpdate addAccountItem(AccountRef accountItem) {
        if (this.account == null) {
            this.account = new ArrayList<AccountRef>();
        }
        this.account.add(accountItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AccountRef> getAccount() {
        return this.account;
    }

    public void setAccount(List<AccountRef> account) {
        this.account = account;
    }

    public CustomerUpdate agreement(List<AgreementRef> agreement) {
        this.agreement = agreement;
        return this;
    }

    public CustomerUpdate addAgreementItem(AgreementRef agreementItem) {
        if (this.agreement == null) {
            this.agreement = new ArrayList<AgreementRef>();
        }
        this.agreement.add(agreementItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AgreementRef> getAgreement() {
        return this.agreement;
    }

    public void setAgreement(List<AgreementRef> agreement) {
        this.agreement = agreement;
    }

    public CustomerUpdate characteristic(List<Characteristic> characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public CustomerUpdate addCharacteristicItem(Characteristic characteristicItem) {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<Characteristic>();
        }
        this.characteristic.add(characteristicItem);
        return this;
    }

    @Schema(description="Describes the characteristic of a customer.")
    @Valid
    public List<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    public void setCharacteristic(List<Characteristic> characteristic) {
        this.characteristic = characteristic;
    }

    public CustomerUpdate contactMedium(List<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
        return this;
    }

    public CustomerUpdate addContactMediumItem(ContactMedium contactMediumItem) {
        if (this.contactMedium == null) {
            this.contactMedium = new ArrayList<ContactMedium>();
        }
        this.contactMedium.add(contactMediumItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ContactMedium> getContactMedium() {
        return this.contactMedium;
    }

    public void setContactMedium(List<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
    }

    public CustomerUpdate creditProfile(List<CreditProfile> creditProfile) {
        this.creditProfile = creditProfile;
        return this;
    }

    public CustomerUpdate addCreditProfileItem(CreditProfile creditProfileItem) {
        if (this.creditProfile == null) {
            this.creditProfile = new ArrayList<CreditProfile>();
        }
        this.creditProfile.add(creditProfileItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<CreditProfile> getCreditProfile() {
        return this.creditProfile;
    }

    public void setCreditProfile(List<CreditProfile> creditProfile) {
        this.creditProfile = creditProfile;
    }

    public CustomerUpdate engagedParty(RelatedParty engagedParty) {
        this.engagedParty = engagedParty;
        return this;
    }

    @Schema(description="The party - an organization or an individual - that is engaged as a customer.")
    @NotNull
    @Valid
    public RelatedParty getEngagedParty() {
        return this.engagedParty;
    }

    public void setEngagedParty(RelatedParty engagedParty) {
        this.engagedParty = engagedParty;
    }

    public CustomerUpdate paymentMethod(List<PaymentMethodRef> paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public CustomerUpdate addPaymentMethodItem(PaymentMethodRef paymentMethodItem) {
        if (this.paymentMethod == null) {
            this.paymentMethod = new ArrayList<PaymentMethodRef>();
        }
        this.paymentMethod.add(paymentMethodItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<PaymentMethodRef> getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(List<PaymentMethodRef> paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public CustomerUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public CustomerUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public CustomerUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The time period that the Customer is valid for.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public CustomerUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public CustomerUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public CustomerUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerUpdate customerUpdate = (CustomerUpdate)o;
        return Objects.equals(this.name, customerUpdate.name) && Objects.equals(this.status, customerUpdate.status) && Objects.equals(this.statusReason, customerUpdate.statusReason) && Objects.equals(this.account, customerUpdate.account) && Objects.equals(this.agreement, customerUpdate.agreement) && Objects.equals(this.characteristic, customerUpdate.characteristic) && Objects.equals(this.contactMedium, customerUpdate.contactMedium) && Objects.equals(this.creditProfile, customerUpdate.creditProfile) && Objects.equals(this.engagedParty, customerUpdate.engagedParty) && Objects.equals(this.paymentMethod, customerUpdate.paymentMethod) && Objects.equals(this.relatedParty, customerUpdate.relatedParty) && Objects.equals(this.validFor, customerUpdate.validFor) && Objects.equals(this.baseType, customerUpdate.baseType) && Objects.equals(this.schemaLocation, customerUpdate.schemaLocation) && Objects.equals(this.type, customerUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.status, this.statusReason, this.account, this.agreement, this.characteristic, this.contactMedium, this.creditProfile, this.engagedParty, this.paymentMethod, this.relatedParty, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerUpdate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    statusReason: ").append(this.toIndentedString(this.statusReason)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    characteristic: ").append(this.toIndentedString(this.characteristic)).append("\n");
        sb.append("    contactMedium: ").append(this.toIndentedString(this.contactMedium)).append("\n");
        sb.append("    creditProfile: ").append(this.toIndentedString(this.creditProfile)).append("\n");
        sb.append("    engagedParty: ").append(this.toIndentedString(this.engagedParty)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

