/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.cm629.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.am651.model.AgreementRef;
import org.etsi.osl.tmf.am666.model.AccountRef;
import org.etsi.osl.tmf.am666.model.PaymentMethodRef;
import org.etsi.osl.tmf.cm629.model.CreditProfile;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm632.model.Characteristic;
import org.etsi.osl.tmf.pm632.model.ContactMedium;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Validated
@Entity(name="Customer")
public class Customer
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="statusReason")
    private String statusReason = null;
    @JsonProperty(value="account")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AccountRef> account = new HashSet<AccountRef>();
    @JsonProperty(value="agreement")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AgreementRef> agreement = new HashSet<AgreementRef>();
    @JsonProperty(value="characteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Characteristic> characteristic = new HashSet<Characteristic>();
    @JsonProperty(value="contactMedium")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ContactMedium> contactMedium = new HashSet<ContactMedium>();
    @JsonProperty(value="creditProfile")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<CreditProfile> creditProfile = new HashSet<CreditProfile>();
    @JsonProperty(value="engagedParty")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(referencedColumnName="uuid")
    private RelatedParty engagedParty = null;
    @JsonProperty(value="paymentMethod")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<PaymentMethodRef> paymentMethod = new HashSet<PaymentMethodRef>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    @Schema(description="Unique identifier for Customers")
    public String getId() {
        return this.uuid;
    }

    public Customer status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="Used to track the lifecycle status of the customer.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Customer statusReason(String statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    @Schema(description="A string providing an explanation on the value of the status lifecycle. For instance if the status is Rejected, statusReason will provide the reason for rejection.")
    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public Customer account(Set<AccountRef> account) {
        this.account = account;
        return this;
    }

    public Customer addAccountItem(AccountRef accountItem) {
        if (this.account == null) {
            this.account = new HashSet<AccountRef>();
        }
        this.account.add(accountItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<AccountRef> getAccount() {
        return this.account;
    }

    public void setAccount(Set<AccountRef> account) {
        this.account = account;
    }

    public Customer agreement(Set<AgreementRef> agreement) {
        this.agreement = agreement;
        return this;
    }

    public Customer addAgreementItem(AgreementRef agreementItem) {
        if (this.agreement == null) {
            this.agreement = new HashSet<AgreementRef>();
        }
        this.agreement.add(agreementItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<AgreementRef> getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Set<AgreementRef> agreement) {
        this.agreement = agreement;
    }

    public Customer characteristic(Set<Characteristic> characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public Customer addCharacteristicItem(Characteristic characteristicItem) {
        if (this.characteristic == null) {
            this.characteristic = new HashSet<Characteristic>();
        }
        this.characteristic.add(characteristicItem);
        return this;
    }

    @Schema(description="Describes the characteristic of a customer.")
    @Valid
    public Set<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    public void setCharacteristic(Set<Characteristic> characteristic) {
        this.characteristic = characteristic;
    }

    public Customer contactMedium(Set<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
        return this;
    }

    public Customer addContactMediumItem(ContactMedium contactMediumItem) {
        if (this.contactMedium == null) {
            this.contactMedium = new HashSet<ContactMedium>();
        }
        this.contactMedium.add(contactMediumItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ContactMedium> getContactMedium() {
        return this.contactMedium;
    }

    public void setContactMedium(Set<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
    }

    public Customer creditProfile(Set<CreditProfile> creditProfile) {
        this.creditProfile = creditProfile;
        return this;
    }

    public Customer addCreditProfileItem(CreditProfile creditProfileItem) {
        if (this.creditProfile == null) {
            this.creditProfile = new HashSet<CreditProfile>();
        }
        this.creditProfile.add(creditProfileItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<CreditProfile> getCreditProfile() {
        return this.creditProfile;
    }

    public void setCreditProfile(Set<CreditProfile> creditProfile) {
        this.creditProfile = creditProfile;
    }

    public Customer engagedParty(RelatedParty engagedParty) {
        this.engagedParty = engagedParty;
        return this;
    }

    @Schema(description="The party - an organization or an individual - that is engaged as a customer.")
    @NotNull
    @Valid
    public RelatedParty getEngagedParty() {
        return this.engagedParty;
    }

    public void setEngagedParty(RelatedParty engagedParty) {
        this.engagedParty = engagedParty;
    }

    public Customer paymentMethod(Set<PaymentMethodRef> paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public Customer addPaymentMethodItem(PaymentMethodRef paymentMethodItem) {
        if (this.paymentMethod == null) {
            this.paymentMethod = new HashSet<PaymentMethodRef>();
        }
        this.paymentMethod.add(paymentMethodItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<PaymentMethodRef> getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(Set<PaymentMethodRef> paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Customer relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Customer addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Customer validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The time period that the Customer is valid for.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Customer customer = (Customer)o;
        return Objects.equals(this.id, customer.id) && Objects.equals(this.href, customer.href) && Objects.equals(this.name, customer.name) && Objects.equals(this.status, customer.status) && Objects.equals(this.statusReason, customer.statusReason) && Objects.equals(this.account, customer.account) && Objects.equals(this.agreement, customer.agreement) && Objects.equals(this.characteristic, customer.characteristic) && Objects.equals(this.contactMedium, customer.contactMedium) && Objects.equals(this.creditProfile, customer.creditProfile) && Objects.equals(this.engagedParty, customer.engagedParty) && Objects.equals(this.paymentMethod, customer.paymentMethod) && Objects.equals(this.relatedParty, customer.relatedParty) && Objects.equals(this.validFor, customer.validFor) && Objects.equals(this.baseType, customer.baseType) && Objects.equals(this.schemaLocation, customer.schemaLocation) && Objects.equals(this.type, customer.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Customer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    statusReason: ").append(this.toIndentedString(this.statusReason)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    characteristic: ").append(this.toIndentedString(this.characteristic)).append("\n");
        sb.append("    contactMedium: ").append(this.toIndentedString(this.contactMedium)).append("\n");
        sb.append("    creditProfile: ").append(this.toIndentedString(this.creditProfile)).append("\n");
        sb.append("    engagedParty: ").append(this.toIndentedString(this.engagedParty)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

