/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am666.model.AccountBalance;
import org.etsi.osl.tmf.am666.model.AccountRelationship;
import org.etsi.osl.tmf.am666.model.AccountTaxExemption;
import org.etsi.osl.tmf.am666.model.BillStructure;
import org.etsi.osl.tmf.am666.model.Contact;
import org.etsi.osl.tmf.am666.model.FinancialAccountRef;
import org.etsi.osl.tmf.am666.model.Money;
import org.etsi.osl.tmf.am666.model.PaymentMethodRef;
import org.etsi.osl.tmf.am666.model.PaymentPlan;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="A party account used for settlement purposes. It includes a description of the bill structure (frequency, presentation media, format and so on). It is a specialization of entity PartyAccount. Skipped properties: id,href")
@Validated
public class SettlementAccountCreate {
    @JsonProperty(value="accountType")
    private String accountType = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="lastModified")
    private OffsetDateTime lastModified = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="paymentStatus")
    private String paymentStatus = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="accountBalance")
    @Valid
    private List<AccountBalance> accountBalance = null;
    @JsonProperty(value="accountRelationship")
    @Valid
    private List<AccountRelationship> accountRelationship = null;
    @JsonProperty(value="billStructure")
    private BillStructure billStructure = null;
    @JsonProperty(value="contact")
    @Valid
    private List<Contact> contact = null;
    @JsonProperty(value="creditLimit")
    private Money creditLimit = null;
    @JsonProperty(value="defaultPaymentMethod")
    private PaymentMethodRef defaultPaymentMethod = null;
    @JsonProperty(value="financialAccount")
    private FinancialAccountRef financialAccount = null;
    @JsonProperty(value="paymentPlan")
    @Valid
    private List<PaymentPlan> paymentPlan = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = new ArrayList<RelatedParty>();
    @JsonProperty(value="taxExemption")
    @Valid
    private List<AccountTaxExemption> taxExemption = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public SettlementAccountCreate accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Schema(description="A categorization of an account, such as individual, joint, and so forth, whose instances share some of the same characteristics. Note: for flexibility we use a String here but an implementation may use an enumeration with a limited list of valid values.")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public SettlementAccountCreate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Detailed description of the party account")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SettlementAccountCreate lastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Schema(description="Date of last modification of the account")
    @Valid
    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public SettlementAccountCreate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the account")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SettlementAccountCreate paymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
        return this;
    }

    @Schema(description="The condition of the account, such as due, paid, in arrears.")
    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public SettlementAccountCreate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Contains the lifecycle state such as: Active, Closed, Suspended and so on.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public SettlementAccountCreate accountBalance(List<AccountBalance> accountBalance) {
        this.accountBalance = accountBalance;
        return this;
    }

    public SettlementAccountCreate addAccountBalanceItem(AccountBalance accountBalanceItem) {
        if (this.accountBalance == null) {
            this.accountBalance = new ArrayList<AccountBalance>();
        }
        this.accountBalance.add(accountBalanceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AccountBalance> getAccountBalance() {
        return this.accountBalance;
    }

    public void setAccountBalance(List<AccountBalance> accountBalance) {
        this.accountBalance = accountBalance;
    }

    public SettlementAccountCreate accountRelationship(List<AccountRelationship> accountRelationship) {
        this.accountRelationship = accountRelationship;
        return this;
    }

    public SettlementAccountCreate addAccountRelationshipItem(AccountRelationship accountRelationshipItem) {
        if (this.accountRelationship == null) {
            this.accountRelationship = new ArrayList<AccountRelationship>();
        }
        this.accountRelationship.add(accountRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AccountRelationship> getAccountRelationship() {
        return this.accountRelationship;
    }

    public void setAccountRelationship(List<AccountRelationship> accountRelationship) {
        this.accountRelationship = accountRelationship;
    }

    public SettlementAccountCreate billStructure(BillStructure billStructure) {
        this.billStructure = billStructure;
        return this;
    }

    @Schema(description="")
    @Valid
    public BillStructure getBillStructure() {
        return this.billStructure;
    }

    public void setBillStructure(BillStructure billStructure) {
        this.billStructure = billStructure;
    }

    public SettlementAccountCreate contact(List<Contact> contact) {
        this.contact = contact;
        return this;
    }

    public SettlementAccountCreate addContactItem(Contact contactItem) {
        if (this.contact == null) {
            this.contact = new ArrayList<Contact>();
        }
        this.contact.add(contactItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Contact> getContact() {
        return this.contact;
    }

    public void setContact(List<Contact> contact) {
        this.contact = contact;
    }

    public SettlementAccountCreate creditLimit(Money creditLimit) {
        this.creditLimit = creditLimit;
        return this;
    }

    @Schema(description="The maximum amount of money that may be charged on an account")
    @Valid
    public Money getCreditLimit() {
        return this.creditLimit;
    }

    public void setCreditLimit(Money creditLimit) {
        this.creditLimit = creditLimit;
    }

    public SettlementAccountCreate defaultPaymentMethod(PaymentMethodRef defaultPaymentMethod) {
        this.defaultPaymentMethod = defaultPaymentMethod;
        return this;
    }

    @Schema(description="")
    @Valid
    public PaymentMethodRef getDefaultPaymentMethod() {
        return this.defaultPaymentMethod;
    }

    public void setDefaultPaymentMethod(PaymentMethodRef defaultPaymentMethod) {
        this.defaultPaymentMethod = defaultPaymentMethod;
    }

    public SettlementAccountCreate financialAccount(FinancialAccountRef financialAccount) {
        this.financialAccount = financialAccount;
        return this;
    }

    @Schema(description="")
    @Valid
    public FinancialAccountRef getFinancialAccount() {
        return this.financialAccount;
    }

    public void setFinancialAccount(FinancialAccountRef financialAccount) {
        this.financialAccount = financialAccount;
    }

    public SettlementAccountCreate paymentPlan(List<PaymentPlan> paymentPlan) {
        this.paymentPlan = paymentPlan;
        return this;
    }

    public SettlementAccountCreate addPaymentPlanItem(PaymentPlan paymentPlanItem) {
        if (this.paymentPlan == null) {
            this.paymentPlan = new ArrayList<PaymentPlan>();
        }
        this.paymentPlan.add(paymentPlanItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<PaymentPlan> getPaymentPlan() {
        return this.paymentPlan;
    }

    public void setPaymentPlan(List<PaymentPlan> paymentPlan) {
        this.paymentPlan = paymentPlan;
    }

    public SettlementAccountCreate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public SettlementAccountCreate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public SettlementAccountCreate taxExemption(List<AccountTaxExemption> taxExemption) {
        this.taxExemption = taxExemption;
        return this;
    }

    public SettlementAccountCreate addTaxExemptionItem(AccountTaxExemption taxExemptionItem) {
        if (this.taxExemption == null) {
            this.taxExemption = new ArrayList<AccountTaxExemption>();
        }
        this.taxExemption.add(taxExemptionItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AccountTaxExemption> getTaxExemption() {
        return this.taxExemption;
    }

    public void setTaxExemption(List<AccountTaxExemption> taxExemption) {
        this.taxExemption = taxExemption;
    }

    public SettlementAccountCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public SettlementAccountCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public SettlementAccountCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettlementAccountCreate settlementAccountCreate = (SettlementAccountCreate)o;
        return Objects.equals(this.accountType, settlementAccountCreate.accountType) && Objects.equals(this.description, settlementAccountCreate.description) && Objects.equals(this.lastModified, settlementAccountCreate.lastModified) && Objects.equals(this.name, settlementAccountCreate.name) && Objects.equals(this.paymentStatus, settlementAccountCreate.paymentStatus) && Objects.equals(this.state, settlementAccountCreate.state) && Objects.equals(this.accountBalance, settlementAccountCreate.accountBalance) && Objects.equals(this.accountRelationship, settlementAccountCreate.accountRelationship) && Objects.equals(this.billStructure, settlementAccountCreate.billStructure) && Objects.equals(this.contact, settlementAccountCreate.contact) && Objects.equals(this.creditLimit, settlementAccountCreate.creditLimit) && Objects.equals(this.defaultPaymentMethod, settlementAccountCreate.defaultPaymentMethod) && Objects.equals(this.financialAccount, settlementAccountCreate.financialAccount) && Objects.equals(this.paymentPlan, settlementAccountCreate.paymentPlan) && Objects.equals(this.relatedParty, settlementAccountCreate.relatedParty) && Objects.equals(this.taxExemption, settlementAccountCreate.taxExemption) && Objects.equals(this.baseType, settlementAccountCreate.baseType) && Objects.equals(this.schemaLocation, settlementAccountCreate.schemaLocation) && Objects.equals(this.type, settlementAccountCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.accountType, this.description, this.lastModified, this.name, this.paymentStatus, this.state, this.accountBalance, this.accountRelationship, this.billStructure, this.contact, this.creditLimit, this.defaultPaymentMethod, this.financialAccount, this.paymentPlan, this.relatedParty, this.taxExemption, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SettlementAccountCreate {\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    paymentStatus: ").append(this.toIndentedString(this.paymentStatus)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    accountBalance: ").append(this.toIndentedString(this.accountBalance)).append("\n");
        sb.append("    accountRelationship: ").append(this.toIndentedString(this.accountRelationship)).append("\n");
        sb.append("    billStructure: ").append(this.toIndentedString(this.billStructure)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    creditLimit: ").append(this.toIndentedString(this.creditLimit)).append("\n");
        sb.append("    defaultPaymentMethod: ").append(this.toIndentedString(this.defaultPaymentMethod)).append("\n");
        sb.append("    financialAccount: ").append(this.toIndentedString(this.financialAccount)).append("\n");
        sb.append("    paymentPlan: ").append(this.toIndentedString(this.paymentPlan)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    taxExemption: ").append(this.toIndentedString(this.taxExemption)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

