/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.am666.model.Money;
import org.etsi.osl.tmf.am666.model.PaymentMethodRef;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Defines a plan for payment (when a party wants to spread his payments)")
@Validated
public class PaymentPlan {
    @JsonProperty(value="numberOfPayments")
    private Integer numberOfPayments = null;
    @JsonProperty(value="paymentFrequency")
    private String paymentFrequency = null;
    @JsonProperty(value="planType")
    private String planType = null;
    @JsonProperty(value="priority")
    private Integer priority = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="paymentMethod")
    private PaymentMethodRef paymentMethod = null;
    @JsonProperty(value="totalAmount")
    private Money totalAmount = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public PaymentPlan numberOfPayments(Integer numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
        return this;
    }

    @Schema(description="Number of payments used to spread the global payment")
    public Integer getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public void setNumberOfPayments(Integer numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
    }

    public PaymentPlan paymentFrequency(String paymentFrequency) {
        this.paymentFrequency = paymentFrequency;
        return this;
    }

    @Schema(description="Frequency of the payments, such as monthly and bimonthly")
    public String getPaymentFrequency() {
        return this.paymentFrequency;
    }

    public void setPaymentFrequency(String paymentFrequency) {
        this.paymentFrequency = paymentFrequency;
    }

    public PaymentPlan planType(String planType) {
        this.planType = planType;
        return this;
    }

    @Schema(description="Type of payment plan")
    public String getPlanType() {
        return this.planType;
    }

    public void setPlanType(String planType) {
        this.planType = planType;
    }

    public PaymentPlan priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="Priority of the payment plan")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public PaymentPlan status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of the payment plan (effective, ineffective)")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PaymentPlan paymentMethod(PaymentMethodRef paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(description="")
    @Valid
    public PaymentMethodRef getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethodRef paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentPlan totalAmount(Money totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Schema(description="Amount paid")
    @Valid
    public Money getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Money totalAmount) {
        this.totalAmount = totalAmount;
    }

    public PaymentPlan validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="Validity period of the payment plan")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public PaymentPlan baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public PaymentPlan schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public PaymentPlan type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentPlan paymentPlan = (PaymentPlan)o;
        return Objects.equals(this.numberOfPayments, paymentPlan.numberOfPayments) && Objects.equals(this.paymentFrequency, paymentPlan.paymentFrequency) && Objects.equals(this.planType, paymentPlan.planType) && Objects.equals(this.priority, paymentPlan.priority) && Objects.equals(this.status, paymentPlan.status) && Objects.equals(this.paymentMethod, paymentPlan.paymentMethod) && Objects.equals(this.totalAmount, paymentPlan.totalAmount) && Objects.equals(this.validFor, paymentPlan.validFor) && Objects.equals(this.baseType, paymentPlan.baseType) && Objects.equals(this.schemaLocation, paymentPlan.schemaLocation) && Objects.equals(this.type, paymentPlan.type);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfPayments, this.paymentFrequency, this.planType, this.priority, this.status, this.paymentMethod, this.totalAmount, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentPlan {\n");
        sb.append("    numberOfPayments: ").append(this.toIndentedString(this.numberOfPayments)).append("\n");
        sb.append("    paymentFrequency: ").append(this.toIndentedString(this.paymentFrequency)).append("\n");
        sb.append("    planType: ").append(this.toIndentedString(this.planType)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

