/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am666.model.AccountBalance;
import org.etsi.osl.tmf.am666.model.AccountRelationship;
import org.etsi.osl.tmf.am666.model.AccountTaxExemption;
import org.etsi.osl.tmf.am666.model.Contact;
import org.etsi.osl.tmf.am666.model.Money;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="An account of money owed by a party to another entity in exchange for goods or services that have been delivered or used. A financial (account receivable account/account payable) aggregates the amounts of one or more party accounts (billing or settlement) owned by a given party. It is a specialization of entity Account. Skipped properties: id,href,lastModified")
@Validated
public class FinancialAccountUpdate {
    @JsonProperty(value="accountType")
    private String accountType = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="accountBalance")
    @Valid
    private List<AccountBalance> accountBalance = null;
    @JsonProperty(value="accountRelationship")
    @Valid
    private List<AccountRelationship> accountRelationship = null;
    @JsonProperty(value="contact")
    @Valid
    private List<Contact> contact = null;
    @JsonProperty(value="creditLimit")
    private Money creditLimit = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @JsonProperty(value="taxExemption")
    @Valid
    private List<AccountTaxExemption> taxExemption = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public FinancialAccountUpdate accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Schema(description="A categorization of an account, such as individual, joint, and so forth, whose instances share some of the same characteristics. Note: for flexibility we use a String here but an implementation may use an enumeration with a limited list of valid values.")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public FinancialAccountUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Detailed description of the party account")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FinancialAccountUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the account")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FinancialAccountUpdate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Contains the lifecycle state such as: Active, Closed, Suspended and so on.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public FinancialAccountUpdate accountBalance(List<AccountBalance> accountBalance) {
        this.accountBalance = accountBalance;
        return this;
    }

    public FinancialAccountUpdate addAccountBalanceItem(AccountBalance accountBalanceItem) {
        if (this.accountBalance == null) {
            this.accountBalance = new ArrayList<AccountBalance>();
        }
        this.accountBalance.add(accountBalanceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AccountBalance> getAccountBalance() {
        return this.accountBalance;
    }

    public void setAccountBalance(List<AccountBalance> accountBalance) {
        this.accountBalance = accountBalance;
    }

    public FinancialAccountUpdate accountRelationship(List<AccountRelationship> accountRelationship) {
        this.accountRelationship = accountRelationship;
        return this;
    }

    public FinancialAccountUpdate addAccountRelationshipItem(AccountRelationship accountRelationshipItem) {
        if (this.accountRelationship == null) {
            this.accountRelationship = new ArrayList<AccountRelationship>();
        }
        this.accountRelationship.add(accountRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AccountRelationship> getAccountRelationship() {
        return this.accountRelationship;
    }

    public void setAccountRelationship(List<AccountRelationship> accountRelationship) {
        this.accountRelationship = accountRelationship;
    }

    public FinancialAccountUpdate contact(List<Contact> contact) {
        this.contact = contact;
        return this;
    }

    public FinancialAccountUpdate addContactItem(Contact contactItem) {
        if (this.contact == null) {
            this.contact = new ArrayList<Contact>();
        }
        this.contact.add(contactItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Contact> getContact() {
        return this.contact;
    }

    public void setContact(List<Contact> contact) {
        this.contact = contact;
    }

    public FinancialAccountUpdate creditLimit(Money creditLimit) {
        this.creditLimit = creditLimit;
        return this;
    }

    @Schema(description="The maximum amount of money that may be charged on an account")
    @Valid
    public Money getCreditLimit() {
        return this.creditLimit;
    }

    public void setCreditLimit(Money creditLimit) {
        this.creditLimit = creditLimit;
    }

    public FinancialAccountUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public FinancialAccountUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public FinancialAccountUpdate taxExemption(List<AccountTaxExemption> taxExemption) {
        this.taxExemption = taxExemption;
        return this;
    }

    public FinancialAccountUpdate addTaxExemptionItem(AccountTaxExemption taxExemptionItem) {
        if (this.taxExemption == null) {
            this.taxExemption = new ArrayList<AccountTaxExemption>();
        }
        this.taxExemption.add(taxExemptionItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AccountTaxExemption> getTaxExemption() {
        return this.taxExemption;
    }

    public void setTaxExemption(List<AccountTaxExemption> taxExemption) {
        this.taxExemption = taxExemption;
    }

    public FinancialAccountUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public FinancialAccountUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public FinancialAccountUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinancialAccountUpdate financialAccountUpdate = (FinancialAccountUpdate)o;
        return Objects.equals(this.accountType, financialAccountUpdate.accountType) && Objects.equals(this.description, financialAccountUpdate.description) && Objects.equals(this.name, financialAccountUpdate.name) && Objects.equals(this.state, financialAccountUpdate.state) && Objects.equals(this.accountBalance, financialAccountUpdate.accountBalance) && Objects.equals(this.accountRelationship, financialAccountUpdate.accountRelationship) && Objects.equals(this.contact, financialAccountUpdate.contact) && Objects.equals(this.creditLimit, financialAccountUpdate.creditLimit) && Objects.equals(this.relatedParty, financialAccountUpdate.relatedParty) && Objects.equals(this.taxExemption, financialAccountUpdate.taxExemption) && Objects.equals(this.baseType, financialAccountUpdate.baseType) && Objects.equals(this.schemaLocation, financialAccountUpdate.schemaLocation) && Objects.equals(this.type, financialAccountUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.accountType, this.description, this.name, this.state, this.accountBalance, this.accountRelationship, this.contact, this.creditLimit, this.relatedParty, this.taxExemption, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FinancialAccountUpdate {\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    accountBalance: ").append(this.toIndentedString(this.accountBalance)).append("\n");
        sb.append("    accountRelationship: ").append(this.toIndentedString(this.accountRelationship)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    creditLimit: ").append(this.toIndentedString(this.creditLimit)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    taxExemption: ").append(this.toIndentedString(this.taxExemption)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

