/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.am666.model.AccountBalance;
import org.springframework.validation.annotation.Validated;

@Schema(description="AccountReceivable reference. An account of money owed by a party to another entity in exchange for goods or services that have been delivered or used. An account receivable aggregates the amounts of one or more party accounts (billing or settlement) owned by a given party.")
@Validated
public class FinancialAccountRef {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="accountBalance")
    private AccountBalance accountBalance = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public FinancialAccountRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the account")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FinancialAccountRef href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Unique reference of the account")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public FinancialAccountRef name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the account")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FinancialAccountRef accountBalance(AccountBalance accountBalance) {
        this.accountBalance = accountBalance;
        return this;
    }

    @Schema(description="")
    @Valid
    public AccountBalance getAccountBalance() {
        return this.accountBalance;
    }

    public void setAccountBalance(AccountBalance accountBalance) {
        this.accountBalance = accountBalance;
    }

    public FinancialAccountRef baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public FinancialAccountRef schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public FinancialAccountRef type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FinancialAccountRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinancialAccountRef financialAccountRef = (FinancialAccountRef)o;
        return Objects.equals(this.id, financialAccountRef.id) && Objects.equals(this.href, financialAccountRef.href) && Objects.equals(this.name, financialAccountRef.name) && Objects.equals(this.accountBalance, financialAccountRef.accountBalance) && Objects.equals(this.baseType, financialAccountRef.baseType) && Objects.equals(this.schemaLocation, financialAccountRef.schemaLocation) && Objects.equals(this.type, financialAccountRef.type) && Objects.equals(this.referredType, financialAccountRef.referredType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.name, this.accountBalance, this.baseType, this.schemaLocation, this.type, this.referredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FinancialAccountRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accountBalance: ").append(this.toIndentedString(this.accountBalance)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

