/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am666.model.ContactMedium;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="An individual or an organization used as a contact point for a given account and accessed via some contact medium.")
@Validated
public class Contact {
    @JsonProperty(value="contactName")
    private String contactName = null;
    @JsonProperty(value="contactType")
    private String contactType = null;
    @JsonProperty(value="partyRoleType")
    private String partyRoleType = null;
    @JsonProperty(value="contactMedium")
    @Valid
    private List<ContactMedium> contactMedium = null;
    @JsonProperty(value="relatedParty")
    private RelatedParty relatedParty = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public Contact contactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    @Schema(description="A displayable name for that contact")
    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public Contact contactType(String contactType) {
        this.contactType = contactType;
        return this;
    }

    @Schema(description="Type of contact (primary, secondary...)")
    @NotNull
    public String getContactType() {
        return this.contactType;
    }

    public void setContactType(String contactType) {
        this.contactType = contactType;
    }

    public Contact partyRoleType(String partyRoleType) {
        this.partyRoleType = partyRoleType;
        return this;
    }

    @Schema(description="Identifies what kind of party role type is linked to the contact (a account manager...)")
    public String getPartyRoleType() {
        return this.partyRoleType;
    }

    public void setPartyRoleType(String partyRoleType) {
        this.partyRoleType = partyRoleType;
    }

    public Contact contactMedium(List<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
        return this;
    }

    public Contact addContactMediumItem(ContactMedium contactMediumItem) {
        if (this.contactMedium == null) {
            this.contactMedium = new ArrayList<ContactMedium>();
        }
        this.contactMedium.add(contactMediumItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ContactMedium> getContactMedium() {
        return this.contactMedium;
    }

    public void setContactMedium(List<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
    }

    public Contact relatedParty(RelatedParty relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    @Schema(description="")
    @Valid
    public RelatedParty getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(RelatedParty relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Contact validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="Validity period of that contact")
    @NotNull
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public Contact baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public Contact schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public Contact type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.contactName, contact.contactName) && Objects.equals(this.contactType, contact.contactType) && Objects.equals(this.partyRoleType, contact.partyRoleType) && Objects.equals(this.contactMedium, contact.contactMedium) && Objects.equals(this.relatedParty, contact.relatedParty) && Objects.equals(this.validFor, contact.validFor) && Objects.equals(this.baseType, contact.baseType) && Objects.equals(this.schemaLocation, contact.schemaLocation) && Objects.equals(this.type, contact.type);
    }

    public int hashCode() {
        return Objects.hash(this.contactName, this.contactType, this.partyRoleType, this.contactMedium, this.relatedParty, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    contactName: ").append(this.toIndentedString(this.contactName)).append("\n");
        sb.append("    contactType: ").append(this.toIndentedString(this.contactType)).append("\n");
        sb.append("    partyRoleType: ").append(this.toIndentedString(this.partyRoleType)).append("\n");
        sb.append("    contactMedium: ").append(this.toIndentedString(this.contactMedium)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

