/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="BillingCycleSpecification reference. A description of when to initiate a billing cycle and the various sub steps of a billing cycle.")
@Validated
public class BillingCycleSpecificationRef {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="dateShift")
    private Integer dateShift = null;
    @JsonProperty(value="frequency")
    private String frequency = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public BillingCycleSpecificationRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the billing cycle specification")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BillingCycleSpecificationRef href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of the billing cycle specification")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public BillingCycleSpecificationRef dateShift(Integer dateShift) {
        this.dateShift = dateShift;
        return this;
    }

    @Schema(description="An offset of a billing/settlement date. The offset is expressed as number of days with regard to the start of the billing/settlement period.")
    public Integer getDateShift() {
        return this.dateShift;
    }

    public void setDateShift(Integer dateShift) {
        this.dateShift = dateShift;
    }

    public BillingCycleSpecificationRef frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @Schema(description="Frequency of the billing cycle (monthly for instance)")
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public BillingCycleSpecificationRef name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A short descriptive name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BillingCycleSpecificationRef baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public BillingCycleSpecificationRef schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public BillingCycleSpecificationRef type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BillingCycleSpecificationRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingCycleSpecificationRef billingCycleSpecificationRef = (BillingCycleSpecificationRef)o;
        return Objects.equals(this.id, billingCycleSpecificationRef.id) && Objects.equals(this.href, billingCycleSpecificationRef.href) && Objects.equals(this.dateShift, billingCycleSpecificationRef.dateShift) && Objects.equals(this.frequency, billingCycleSpecificationRef.frequency) && Objects.equals(this.name, billingCycleSpecificationRef.name) && Objects.equals(this.baseType, billingCycleSpecificationRef.baseType) && Objects.equals(this.schemaLocation, billingCycleSpecificationRef.schemaLocation) && Objects.equals(this.type, billingCycleSpecificationRef.type) && Objects.equals(this.referredType, billingCycleSpecificationRef.referredType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.dateShift, this.frequency, this.name, this.baseType, this.schemaLocation, this.type, this.referredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingCycleSpecificationRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    dateShift: ").append(this.toIndentedString(this.dateShift)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

