/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="A detailed description of when to initiate a billing cycle and the various sub steps of a billing cycle. Skipped properties: id,href")
@Validated
public class BillingCycleSpecificationCreate {
    @JsonProperty(value="billingDateShift")
    private Integer billingDateShift = null;
    @JsonProperty(value="billingPeriod")
    private String billingPeriod = null;
    @JsonProperty(value="chargeDateOffset")
    private Integer chargeDateOffset = null;
    @JsonProperty(value="creditDateOffset")
    private Integer creditDateOffset = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="frequency")
    private String frequency = null;
    @JsonProperty(value="mailingDateOffset")
    private Integer mailingDateOffset = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="paymentDueDateOffset")
    private Integer paymentDueDateOffset = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public BillingCycleSpecificationCreate billingDateShift(Integer billingDateShift) {
        this.billingDateShift = billingDateShift;
        return this;
    }

    @Schema(description="An offset of a billing/settlement date. The offset is expressed as number of days with regard to the start of the billing/settlement period.")
    public Integer getBillingDateShift() {
        return this.billingDateShift;
    }

    public void setBillingDateShift(Integer billingDateShift) {
        this.billingDateShift = billingDateShift;
    }

    public BillingCycleSpecificationCreate billingPeriod(String billingPeriod) {
        this.billingPeriod = billingPeriod;
        return this;
    }

    @Schema(description="A billing time period. It can be recurring, for example: week, month, quarter of year, year .")
    public String getBillingPeriod() {
        return this.billingPeriod;
    }

    public void setBillingPeriod(String billingPeriod) {
        this.billingPeriod = billingPeriod;
    }

    public BillingCycleSpecificationCreate chargeDateOffset(Integer chargeDateOffset) {
        this.chargeDateOffset = chargeDateOffset;
        return this;
    }

    @Schema(description="An offset of a date through which charges previously received by the billing system will appear on the bill. The offset is expressed as number of days with regard to the start of the BillingPeriod.")
    public Integer getChargeDateOffset() {
        return this.chargeDateOffset;
    }

    public void setChargeDateOffset(Integer chargeDateOffset) {
        this.chargeDateOffset = chargeDateOffset;
    }

    public BillingCycleSpecificationCreate creditDateOffset(Integer creditDateOffset) {
        this.creditDateOffset = creditDateOffset;
        return this;
    }

    @Schema(description="An offset of a date through which credits previously received by the billing system will appear on the bill. The offset is expressed as number of days with regard to the start of the BillingPeriod.")
    public Integer getCreditDateOffset() {
        return this.creditDateOffset;
    }

    public void setCreditDateOffset(Integer creditDateOffset) {
        this.creditDateOffset = creditDateOffset;
    }

    public BillingCycleSpecificationCreate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="An explanation regarding this billing cycle specification")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BillingCycleSpecificationCreate frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @Schema(description="Frequency of the billing cycle (monthly for instance)")
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public BillingCycleSpecificationCreate mailingDateOffset(Integer mailingDateOffset) {
        this.mailingDateOffset = mailingDateOffset;
        return this;
    }

    @Schema(description="An offset of a customer bill mailing date. The offset is expressed as number of days with regard to the start of the BillingPeriod.")
    public Integer getMailingDateOffset() {
        return this.mailingDateOffset;
    }

    public void setMailingDateOffset(Integer mailingDateOffset) {
        this.mailingDateOffset = mailingDateOffset;
    }

    public BillingCycleSpecificationCreate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A short descriptive name")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BillingCycleSpecificationCreate paymentDueDateOffset(Integer paymentDueDateOffset) {
        this.paymentDueDateOffset = paymentDueDateOffset;
        return this;
    }

    @Schema(description="An offset of a payment due date. The offset is expressed as number of days with regard to the start of the BillingPeriod.")
    public Integer getPaymentDueDateOffset() {
        return this.paymentDueDateOffset;
    }

    public void setPaymentDueDateOffset(Integer paymentDueDateOffset) {
        this.paymentDueDateOffset = paymentDueDateOffset;
    }

    public BillingCycleSpecificationCreate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the billing specification cycle is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public BillingCycleSpecificationCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public BillingCycleSpecificationCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public BillingCycleSpecificationCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingCycleSpecificationCreate billingCycleSpecificationCreate = (BillingCycleSpecificationCreate)o;
        return Objects.equals(this.billingDateShift, billingCycleSpecificationCreate.billingDateShift) && Objects.equals(this.billingPeriod, billingCycleSpecificationCreate.billingPeriod) && Objects.equals(this.chargeDateOffset, billingCycleSpecificationCreate.chargeDateOffset) && Objects.equals(this.creditDateOffset, billingCycleSpecificationCreate.creditDateOffset) && Objects.equals(this.description, billingCycleSpecificationCreate.description) && Objects.equals(this.frequency, billingCycleSpecificationCreate.frequency) && Objects.equals(this.mailingDateOffset, billingCycleSpecificationCreate.mailingDateOffset) && Objects.equals(this.name, billingCycleSpecificationCreate.name) && Objects.equals(this.paymentDueDateOffset, billingCycleSpecificationCreate.paymentDueDateOffset) && Objects.equals(this.validFor, billingCycleSpecificationCreate.validFor) && Objects.equals(this.baseType, billingCycleSpecificationCreate.baseType) && Objects.equals(this.schemaLocation, billingCycleSpecificationCreate.schemaLocation) && Objects.equals(this.type, billingCycleSpecificationCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.billingDateShift, this.billingPeriod, this.chargeDateOffset, this.creditDateOffset, this.description, this.frequency, this.mailingDateOffset, this.name, this.paymentDueDateOffset, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingCycleSpecificationCreate {\n");
        sb.append("    billingDateShift: ").append(this.toIndentedString(this.billingDateShift)).append("\n");
        sb.append("    billingPeriod: ").append(this.toIndentedString(this.billingPeriod)).append("\n");
        sb.append("    chargeDateOffset: ").append(this.toIndentedString(this.chargeDateOffset)).append("\n");
        sb.append("    creditDateOffset: ").append(this.toIndentedString(this.creditDateOffset)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    mailingDateOffset: ").append(this.toIndentedString(this.mailingDateOffset)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    paymentDueDateOffset: ").append(this.toIndentedString(this.paymentDueDateOffset)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

