/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am666.model.BillFormatRefOrValue;
import org.etsi.osl.tmf.am666.model.BillPresentationMediaRefOrValue;
import org.etsi.osl.tmf.am666.model.BillingCycleSpecificationRefOrValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="The structure of the bill for party accounts (billing or settlement).")
@Validated
public class BillStructure {
    @JsonProperty(value="cycleSpecification")
    private BillingCycleSpecificationRefOrValue cycleSpecification = null;
    @JsonProperty(value="format")
    private BillFormatRefOrValue format = null;
    @JsonProperty(value="presentationMedia")
    @Valid
    private List<BillPresentationMediaRefOrValue> presentationMedia = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public BillStructure cycleSpecification(BillingCycleSpecificationRefOrValue cycleSpecification) {
        this.cycleSpecification = cycleSpecification;
        return this;
    }

    @Schema(description="")
    @Valid
    public BillingCycleSpecificationRefOrValue getCycleSpecification() {
        return this.cycleSpecification;
    }

    public void setCycleSpecification(BillingCycleSpecificationRefOrValue cycleSpecification) {
        this.cycleSpecification = cycleSpecification;
    }

    public BillStructure format(BillFormatRefOrValue format) {
        this.format = format;
        return this;
    }

    @Schema(description="")
    @Valid
    public BillFormatRefOrValue getFormat() {
        return this.format;
    }

    public void setFormat(BillFormatRefOrValue format) {
        this.format = format;
    }

    public BillStructure presentationMedia(List<BillPresentationMediaRefOrValue> presentationMedia) {
        this.presentationMedia = presentationMedia;
        return this;
    }

    public BillStructure addPresentationMediaItem(BillPresentationMediaRefOrValue presentationMediaItem) {
        if (this.presentationMedia == null) {
            this.presentationMedia = new ArrayList<BillPresentationMediaRefOrValue>();
        }
        this.presentationMedia.add(presentationMediaItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<BillPresentationMediaRefOrValue> getPresentationMedia() {
        return this.presentationMedia;
    }

    public void setPresentationMedia(List<BillPresentationMediaRefOrValue> presentationMedia) {
        this.presentationMedia = presentationMedia;
    }

    public BillStructure baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public BillStructure schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public BillStructure type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillStructure billStructure = (BillStructure)o;
        return Objects.equals(this.cycleSpecification, billStructure.cycleSpecification) && Objects.equals(this.format, billStructure.format) && Objects.equals(this.presentationMedia, billStructure.presentationMedia) && Objects.equals(this.baseType, billStructure.baseType) && Objects.equals(this.schemaLocation, billStructure.schemaLocation) && Objects.equals(this.type, billStructure.type);
    }

    public int hashCode() {
        return Objects.hash(this.cycleSpecification, this.format, this.presentationMedia, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillStructure {\n");
        sb.append("    cycleSpecification: ").append(this.toIndentedString(this.cycleSpecification)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    presentationMedia: ").append(this.toIndentedString(this.presentationMedia)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

