/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Proof of freedom from taxes imposed by a taxing jurisdiction")
@Validated
public class AccountTaxExemption {
    @JsonProperty(value="certificateNumber")
    private String certificateNumber = null;
    @JsonProperty(value="issuingJurisdiction")
    private String issuingJurisdiction = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public AccountTaxExemption certificateNumber(String certificateNumber) {
        this.certificateNumber = certificateNumber;
        return this;
    }

    @Schema(description="Identifier of a document that shows proof of exemption from taxes for the taxing jurisdiction")
    public String getCertificateNumber() {
        return this.certificateNumber;
    }

    public void setCertificateNumber(String certificateNumber) {
        this.certificateNumber = certificateNumber;
    }

    public AccountTaxExemption issuingJurisdiction(String issuingJurisdiction) {
        this.issuingJurisdiction = issuingJurisdiction;
        return this;
    }

    @Schema(description="Name of the taxing jurisdiction for which taxes are exempt")
    @NotNull
    public String getIssuingJurisdiction() {
        return this.issuingJurisdiction;
    }

    public void setIssuingJurisdiction(String issuingJurisdiction) {
        this.issuingJurisdiction = issuingJurisdiction;
    }

    public AccountTaxExemption reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Schema(description="Reason of the tax exemption")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public AccountTaxExemption validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="Period for which the exemption is valid")
    @NotNull
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public AccountTaxExemption baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public AccountTaxExemption schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public AccountTaxExemption type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountTaxExemption accountTaxExemption = (AccountTaxExemption)o;
        return Objects.equals(this.certificateNumber, accountTaxExemption.certificateNumber) && Objects.equals(this.issuingJurisdiction, accountTaxExemption.issuingJurisdiction) && Objects.equals(this.reason, accountTaxExemption.reason) && Objects.equals(this.validFor, accountTaxExemption.validFor) && Objects.equals(this.baseType, accountTaxExemption.baseType) && Objects.equals(this.schemaLocation, accountTaxExemption.schemaLocation) && Objects.equals(this.type, accountTaxExemption.type);
    }

    public int hashCode() {
        return Objects.hash(this.certificateNumber, this.issuingJurisdiction, this.reason, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountTaxExemption {\n");
        sb.append("    certificateNumber: ").append(this.toIndentedString(this.certificateNumber)).append("\n");
        sb.append("    issuingJurisdiction: ").append(this.toIndentedString(this.issuingJurisdiction)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

