/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am666.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.am666.model.Money;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Balances linked to the account")
@Validated
public class AccountBalance {
    @JsonProperty(value="balanceType")
    private String balanceType = null;
    @JsonProperty(value="amount")
    private Money amount = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public AccountBalance balanceType(String balanceType) {
        this.balanceType = balanceType;
        return this;
    }

    @Schema(description="Type of the balance : deposit balance, disputed balance, loyalty balance, receivable balance...")
    @NotNull
    public String getBalanceType() {
        return this.balanceType;
    }

    public void setBalanceType(String balanceType) {
        this.balanceType = balanceType;
    }

    public AccountBalance amount(Money amount) {
        this.amount = amount;
        return this;
    }

    @Schema(description="Balance amount")
    @NotNull
    @Valid
    public Money getAmount() {
        return this.amount;
    }

    public void setAmount(Money amount) {
        this.amount = amount;
    }

    public AccountBalance validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="Balance validity period")
    @NotNull
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public AccountBalance baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public AccountBalance schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public AccountBalance type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountBalance accountBalance = (AccountBalance)o;
        return Objects.equals(this.balanceType, accountBalance.balanceType) && Objects.equals(this.amount, accountBalance.amount) && Objects.equals(this.validFor, accountBalance.validFor) && Objects.equals(this.baseType, accountBalance.baseType) && Objects.equals(this.schemaLocation, accountBalance.schemaLocation) && Objects.equals(this.type, accountBalance.type);
    }

    public int hashCode() {
        return Objects.hash(this.balanceType, this.amount, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountBalance {\n");
        sb.append("    balanceType: ").append(this.toIndentedString(this.balanceType)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

