/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="RelatedParty reference. A related party defines party or party role linked to a specific entity.")
@Validated
public class RelatedPartyRef {
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public RelatedPartyRef href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of the related party, could be a party reference or a party role reference")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public RelatedPartyRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of a related party")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RelatedPartyRef name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the related party")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RelatedPartyRef role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="Role of the related party.")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public RelatedPartyRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedPartyRef relatedPartyRef = (RelatedPartyRef)o;
        return Objects.equals(this.href, relatedPartyRef.href) && Objects.equals(this.id, relatedPartyRef.id) && Objects.equals(this.name, relatedPartyRef.name) && Objects.equals(this.role, relatedPartyRef.role) && Objects.equals(this.referredType, relatedPartyRef.referredType);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.id, this.name, this.role, this.referredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedPartyRef {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

