/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="Party role reference. A party role represents the part played by a party in a given context.")
@Validated
public class PartyRoleRef {
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="partyId")
    private String partyId = null;
    @JsonProperty(value="partyName")
    private String partyName = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public PartyRoleRef href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of the product")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public PartyRoleRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the product")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PartyRoleRef name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of the referred party role.")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PartyRoleRef partyId(String partyId) {
        this.partyId = partyId;
        return this;
    }

    @Schema(description="The identifier of the engaged party that is linked to the PartyRole object.")
    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public PartyRoleRef partyName(String partyName) {
        this.partyName = partyName;
        return this;
    }

    @Schema(description="The name of the engaged party that is linked to the PartyRole object.")
    public String getPartyName() {
        return this.partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }

    public PartyRoleRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartyRoleRef partyRoleRef = (PartyRoleRef)o;
        return Objects.equals(this.href, partyRoleRef.href) && Objects.equals(this.id, partyRoleRef.id) && Objects.equals(this.name, partyRoleRef.name) && Objects.equals(this.partyId, partyRoleRef.partyId) && Objects.equals(this.partyName, partyRoleRef.partyName) && Objects.equals(this.referredType, partyRoleRef.referredType);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.id, this.name, this.partyId, this.partyName, this.referredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartyRoleRef {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    partyId: ").append(this.toIndentedString(this.partyId)).append("\n");
        sb.append("    partyName: ").append(this.toIndentedString(this.partyName)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

