/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Aspects of the agreement not formally specified elsewhere in the agreement and that cannot be captured elsewhere in a formal notation, or automatically monitored and require a more human level of management.")
@Validated
public class AgreementTermOrCondition {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@type")
    private String type = null;

    public AgreementTermOrCondition description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Text that explains the term or condition of the agreement.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AgreementTermOrCondition id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique number assigned for reference.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AgreementTermOrCondition validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period of time during which the term or condition of the agreement applies.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public AgreementTermOrCondition type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgreementTermOrCondition agreementTermOrCondition = (AgreementTermOrCondition)o;
        return Objects.equals(this.description, agreementTermOrCondition.description) && Objects.equals(this.id, agreementTermOrCondition.id) && Objects.equals(this.validFor, agreementTermOrCondition.validFor) && Objects.equals(this.type, agreementTermOrCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.validFor, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementTermOrCondition {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

