/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="A relationship between agreement specifications. Typical relationships are substitution and dependency.")
@Validated
public class AgreementSpecificationRelationship {
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="type")
    private String typeAgreementSpecificationRelationship = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@type")
    private String type = null;

    public AgreementSpecificationRelationship href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of an agreement specification.")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public AgreementSpecificationRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the related agreement specification.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AgreementSpecificationRelationship typeAgreementSpecificationRelationship(String type) {
        this.typeAgreementSpecificationRelationship = type;
        return this;
    }

    @Schema(description="Type of relationship such as, substitution or dependency.")
    public String getTypeAgreementSpecificationRelationship() {
        return this.typeAgreementSpecificationRelationship;
    }

    public void setTypeAgreementSpecificationRelationship(String type) {
        this.typeAgreementSpecificationRelationship = type;
    }

    public AgreementSpecificationRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the relationship is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public AgreementSpecificationRelationship type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgreementSpecificationRelationship agreementSpecificationRelationship = (AgreementSpecificationRelationship)o;
        return Objects.equals(this.href, agreementSpecificationRelationship.href) && Objects.equals(this.id, agreementSpecificationRelationship.id) && Objects.equals(this.type, agreementSpecificationRelationship.type) && Objects.equals(this.validFor, agreementSpecificationRelationship.validFor) && Objects.equals(this.type, agreementSpecificationRelationship.type);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.id, this.type, this.validFor, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementSpecificationRelationship {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

