/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="AgreementSpecification reference. An AgreementSpecification represents a template of an agreement that can be used when establishing partnerships.")
@Validated
public class AgreementSpecificationRef {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public AgreementSpecificationRef description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail what the agreement specification is about.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AgreementSpecificationRef href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference URL of the agreement specification")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public AgreementSpecificationRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the agreement specification")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AgreementSpecificationRef name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the agreement specification")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AgreementSpecificationRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgreementSpecificationRef agreementSpecificationRef = (AgreementSpecificationRef)o;
        return Objects.equals(this.description, agreementSpecificationRef.description) && Objects.equals(this.href, agreementSpecificationRef.href) && Objects.equals(this.id, agreementSpecificationRef.id) && Objects.equals(this.name, agreementSpecificationRef.name) && Objects.equals(this.referredType, agreementSpecificationRef.referredType);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.href, this.id, this.name, this.referredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementSpecificationRef {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

