/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am651.model.AgreementAttachment;
import org.etsi.osl.tmf.am651.model.AgreementSpecCharacteristic;
import org.etsi.osl.tmf.am651.model.AgreementSpecificationRelationship;
import org.etsi.osl.tmf.am651.model.CategoryRef;
import org.etsi.osl.tmf.am651.model.RelatedPartyRef;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="A template of an agreement that can be used when establishing partnerships.")
@Validated
public class AgreementSpecification {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="isBundle")
    private Boolean isBundle = null;
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;
    @JsonProperty(value="lifecycleStatus")
    private String lifecycleStatus = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="serviceCategory")
    private CategoryRef serviceCategory = null;
    @JsonProperty(value="specCharacteristic")
    @Valid
    private List<AgreementSpecCharacteristic> specCharacteristic = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedPartyRef> relatedParty = null;
    @JsonProperty(value="attachment")
    @Valid
    private List<AgreementAttachment> attachment = null;
    @JsonProperty(value="specificationRelationship")
    @Valid
    private List<AgreementSpecificationRelationship> specificationRelationship = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;

    public AgreementSpecification description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail what the agreement specification is about.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AgreementSpecification href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of the agreement specification")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public AgreementSpecification id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the agreement specification")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AgreementSpecification isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="Indicates that this agreement specification is a grouping of other agreement specifications. The list of bundled agreement specifications is provided via the specificationRelationship property.")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public AgreementSpecification lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public AgreementSpecification lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Indicates the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public AgreementSpecification name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the agreement specification")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AgreementSpecification validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the agreement specification is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public AgreementSpecification version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Agreement specification version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public AgreementSpecification serviceCategory(CategoryRef serviceCategory) {
        this.serviceCategory = serviceCategory;
        return this;
    }

    @Schema(description="")
    @Valid
    public CategoryRef getServiceCategory() {
        return this.serviceCategory;
    }

    public void setServiceCategory(CategoryRef serviceCategory) {
        this.serviceCategory = serviceCategory;
    }

    public AgreementSpecification specCharacteristic(List<AgreementSpecCharacteristic> specCharacteristic) {
        this.specCharacteristic = specCharacteristic;
        return this;
    }

    public AgreementSpecification addSpecCharacteristicItem(AgreementSpecCharacteristic specCharacteristicItem) {
        if (this.specCharacteristic == null) {
            this.specCharacteristic = new ArrayList<AgreementSpecCharacteristic>();
        }
        this.specCharacteristic.add(specCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AgreementSpecCharacteristic> getSpecCharacteristic() {
        return this.specCharacteristic;
    }

    public void setSpecCharacteristic(List<AgreementSpecCharacteristic> specCharacteristic) {
        this.specCharacteristic = specCharacteristic;
    }

    public AgreementSpecification relatedParty(List<RelatedPartyRef> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public AgreementSpecification addRelatedPartyItem(RelatedPartyRef relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedPartyRef>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedPartyRef> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedPartyRef> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public AgreementSpecification attachment(List<AgreementAttachment> attachment) {
        this.attachment = attachment;
        return this;
    }

    public AgreementSpecification addAttachmentItem(AgreementAttachment attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AgreementAttachment>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AgreementAttachment> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AgreementAttachment> attachment) {
        this.attachment = attachment;
    }

    public AgreementSpecification specificationRelationship(List<AgreementSpecificationRelationship> specificationRelationship) {
        this.specificationRelationship = specificationRelationship;
        return this;
    }

    public AgreementSpecification addSpecificationRelationshipItem(AgreementSpecificationRelationship specificationRelationshipItem) {
        if (this.specificationRelationship == null) {
            this.specificationRelationship = new ArrayList<AgreementSpecificationRelationship>();
        }
        this.specificationRelationship.add(specificationRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AgreementSpecificationRelationship> getSpecificationRelationship() {
        return this.specificationRelationship;
    }

    public void setSpecificationRelationship(List<AgreementSpecificationRelationship> specificationRelationship) {
        this.specificationRelationship = specificationRelationship;
    }

    public AgreementSpecification type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AgreementSpecification schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public AgreementSpecification baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The base type for use in polymorphic collections")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgreementSpecification agreementSpecification = (AgreementSpecification)o;
        return Objects.equals(this.description, agreementSpecification.description) && Objects.equals(this.href, agreementSpecification.href) && Objects.equals(this.id, agreementSpecification.id) && Objects.equals(this.isBundle, agreementSpecification.isBundle) && Objects.equals(this.lastUpdate, agreementSpecification.lastUpdate) && Objects.equals(this.lifecycleStatus, agreementSpecification.lifecycleStatus) && Objects.equals(this.name, agreementSpecification.name) && Objects.equals(this.validFor, agreementSpecification.validFor) && Objects.equals(this.version, agreementSpecification.version) && Objects.equals(this.serviceCategory, agreementSpecification.serviceCategory) && Objects.equals(this.specCharacteristic, agreementSpecification.specCharacteristic) && Objects.equals(this.relatedParty, agreementSpecification.relatedParty) && Objects.equals(this.attachment, agreementSpecification.attachment) && Objects.equals(this.specificationRelationship, agreementSpecification.specificationRelationship) && Objects.equals(this.type, agreementSpecification.type) && Objects.equals(this.schemaLocation, agreementSpecification.schemaLocation) && Objects.equals(this.baseType, agreementSpecification.baseType);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.href, this.id, this.isBundle, this.lastUpdate, this.lifecycleStatus, this.name, this.validFor, this.version, this.serviceCategory, this.specCharacteristic, this.relatedParty, this.attachment, this.specificationRelationship, this.type, this.schemaLocation, this.baseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementSpecification {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    serviceCategory: ").append(this.toIndentedString(this.serviceCategory)).append("\n");
        sb.append("    specCharacteristic: ").append(this.toIndentedString(this.specCharacteristic)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    specificationRelationship: ").append(this.toIndentedString(this.specificationRelationship)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

