/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="A number or text that can be assigned to an agreement specification characteristic.")
@Validated
public class AgreementSpecCharacteristicValue {
    @JsonProperty(value="default")
    private Boolean _default = null;
    @JsonProperty(value="unitOfMeasure")
    private String unitOfMeasure = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="valueFrom")
    private String valueFrom = null;
    @JsonProperty(value="valueTo")
    private String valueTo = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="@type")
    private String type = null;

    public AgreementSpecCharacteristicValue _default(Boolean _default) {
        this._default = _default;
        return this;
    }

    @Schema(description="Indicates if the value is the default value for a characteristic")
    public Boolean isDefault() {
        return this._default;
    }

    public void setDefault(Boolean _default) {
        this._default = _default;
    }

    public AgreementSpecCharacteristicValue unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="Unit of measure for the characteristic, such as minutes, gigabytes (GB) and so on.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public AgreementSpecCharacteristicValue validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period of time for which a value is applicable")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public AgreementSpecCharacteristicValue value(String value) {
        this.value = value;
        return this;
    }

    @Schema(description="A discrete value that the characteristic can take on")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public AgreementSpecCharacteristicValue valueFrom(String valueFrom) {
        this.valueFrom = valueFrom;
        return this;
    }

    @Schema(description="The low range value that a characteristic can take on")
    public String getValueFrom() {
        return this.valueFrom;
    }

    public void setValueFrom(String valueFrom) {
        this.valueFrom = valueFrom;
    }

    public AgreementSpecCharacteristicValue valueTo(String valueTo) {
        this.valueTo = valueTo;
        return this;
    }

    @Schema(description="The upper range value that a characteristic can take on")
    public String getValueTo() {
        return this.valueTo;
    }

    public void setValueTo(String valueTo) {
        this.valueTo = valueTo;
    }

    public AgreementSpecCharacteristicValue valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on, such as numeric, text, and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public AgreementSpecCharacteristicValue type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgreementSpecCharacteristicValue agreementSpecCharacteristicValue = (AgreementSpecCharacteristicValue)o;
        return Objects.equals(this._default, agreementSpecCharacteristicValue._default) && Objects.equals(this.unitOfMeasure, agreementSpecCharacteristicValue.unitOfMeasure) && Objects.equals(this.validFor, agreementSpecCharacteristicValue.validFor) && Objects.equals(this.value, agreementSpecCharacteristicValue.value) && Objects.equals(this.valueFrom, agreementSpecCharacteristicValue.valueFrom) && Objects.equals(this.valueTo, agreementSpecCharacteristicValue.valueTo) && Objects.equals(this.valueType, agreementSpecCharacteristicValue.valueType) && Objects.equals(this.type, agreementSpecCharacteristicValue.type);
    }

    public int hashCode() {
        return Objects.hash(this._default, this.unitOfMeasure, this.validFor, this.value, this.valueFrom, this.valueTo, this.valueType, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementSpecCharacteristicValue {\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueFrom: ").append(this.toIndentedString(this.valueFrom)).append("\n");
        sb.append("    valueTo: ").append(this.toIndentedString(this.valueTo)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

