/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am651.model.AgreementSpecCharacteristicValue;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="A characteristic quality or distinctive feature of an agreement.")
@Validated
public class AgreementSpecCharacteristic {
    @JsonProperty(value="configurable")
    private Boolean configurable = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="specCharacteristicValue")
    @Valid
    private List<AgreementSpecCharacteristicValue> specCharacteristicValue = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;

    public AgreementSpecCharacteristic configurable(Boolean configurable) {
        this.configurable = configurable;
        return this;
    }

    @Schema(description="If true, the Boolean indicates that the characteristic is configurable")
    public Boolean isConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    public AgreementSpecCharacteristic description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail what the characteristic is")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AgreementSpecCharacteristic name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the characteristic being specified.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AgreementSpecCharacteristic validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the specification characteristic is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public AgreementSpecCharacteristic valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on, such as numeric, text and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public AgreementSpecCharacteristic specCharacteristicValue(List<AgreementSpecCharacteristicValue> specCharacteristicValue) {
        this.specCharacteristicValue = specCharacteristicValue;
        return this;
    }

    public AgreementSpecCharacteristic addSpecCharacteristicValueItem(AgreementSpecCharacteristicValue specCharacteristicValueItem) {
        if (this.specCharacteristicValue == null) {
            this.specCharacteristicValue = new ArrayList<AgreementSpecCharacteristicValue>();
        }
        this.specCharacteristicValue.add(specCharacteristicValueItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AgreementSpecCharacteristicValue> getSpecCharacteristicValue() {
        return this.specCharacteristicValue;
    }

    public void setSpecCharacteristicValue(List<AgreementSpecCharacteristicValue> specCharacteristicValue) {
        this.specCharacteristicValue = specCharacteristicValue;
    }

    public AgreementSpecCharacteristic type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AgreementSpecCharacteristic schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgreementSpecCharacteristic agreementSpecCharacteristic = (AgreementSpecCharacteristic)o;
        return Objects.equals(this.configurable, agreementSpecCharacteristic.configurable) && Objects.equals(this.description, agreementSpecCharacteristic.description) && Objects.equals(this.name, agreementSpecCharacteristic.name) && Objects.equals(this.validFor, agreementSpecCharacteristic.validFor) && Objects.equals(this.valueType, agreementSpecCharacteristic.valueType) && Objects.equals(this.specCharacteristicValue, agreementSpecCharacteristic.specCharacteristicValue) && Objects.equals(this.type, agreementSpecCharacteristic.type) && Objects.equals(this.schemaLocation, agreementSpecCharacteristic.schemaLocation);
    }

    public int hashCode() {
        return Objects.hash(this.configurable, this.description, this.name, this.validFor, this.valueType, this.specCharacteristicValue, this.type, this.schemaLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementSpecCharacteristic {\n");
        sb.append("    configurable: ").append(this.toIndentedString(this.configurable)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    specCharacteristicValue: ").append(this.toIndentedString(this.specCharacteristicValue)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

