/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am651.model.AgreementAuthorization;
import org.etsi.osl.tmf.am651.model.AgreementItem;
import org.etsi.osl.tmf.am651.model.AgreementRef;
import org.etsi.osl.tmf.am651.model.AgreementSpecificationRef;
import org.etsi.osl.tmf.am651.model.PartyRoleRef;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.springframework.validation.annotation.Validated;

@Schema(description="An agreement represents a contract or arrangement, either written or verbal and sometimes enforceable by law, such as a service level agreement or a customer price agreement. An agreement involves a number of other business entities, such as products, services, and resources and/or their specifications. Skipped properties: id,href")
@Validated
public class AgreementCreate {
    @JsonProperty(value="agreementPeriod")
    private TimePeriod agreementPeriod = null;
    @JsonProperty(value="completionDate")
    private TimePeriod completionDate = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="documentNumber")
    private Integer documentNumber = null;
    @JsonProperty(value="initialDate")
    private OffsetDateTime initialDate = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="statementOfIntent")
    private String statementOfIntent = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="type")
    private String typeAgreementCreate = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="agreementSpecification")
    private AgreementSpecificationRef agreementSpecification = null;
    @JsonProperty(value="agreementItem")
    @Valid
    private List<AgreementItem> agreementItem = new ArrayList<AgreementItem>();
    @JsonProperty(value="engagedPartyRole")
    @Valid
    private List<PartyRoleRef> engagedPartyRole = new ArrayList<PartyRoleRef>();
    @JsonProperty(value="agreementAuthorization")
    @Valid
    private List<AgreementAuthorization> agreementAuthorization = null;
    @JsonProperty(value="characteristic")
    @Valid
    private List<Characteristic> characteristic = null;
    @JsonProperty(value="associatedAgreement")
    @Valid
    private List<AgreementRef> associatedAgreement = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;

    public AgreementCreate agreementPeriod(TimePeriod agreementPeriod) {
        this.agreementPeriod = agreementPeriod;
        return this;
    }

    @Schema(description="The time period during which the Agreement is in effect.")
    @Valid
    public TimePeriod getAgreementPeriod() {
        return this.agreementPeriod;
    }

    public void setAgreementPeriod(TimePeriod agreementPeriod) {
        this.agreementPeriod = agreementPeriod;
    }

    public AgreementCreate completionDate(TimePeriod completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Schema(description="Date at which the agreement is completed")
    @Valid
    public TimePeriod getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(TimePeriod completionDate) {
        this.completionDate = completionDate;
    }

    public AgreementCreate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Narrative that explains the agreement and details about the it , such as why the agreement is taking place.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AgreementCreate documentNumber(Integer documentNumber) {
        this.documentNumber = documentNumber;
        return this;
    }

    @Schema(description="A reference number assigned to an Agreement that follows a prescribed numbering system.")
    public Integer getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(Integer documentNumber) {
        this.documentNumber = documentNumber;
    }

    public AgreementCreate initialDate(OffsetDateTime initialDate) {
        this.initialDate = initialDate;
        return this;
    }

    @Schema(description="Date at which the agreement was initialized")
    @Valid
    public OffsetDateTime getInitialDate() {
        return this.initialDate;
    }

    public void setInitialDate(OffsetDateTime initialDate) {
        this.initialDate = initialDate;
    }

    public AgreementCreate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A human-readable name for the agreement")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AgreementCreate statementOfIntent(String statementOfIntent) {
        this.statementOfIntent = statementOfIntent;
        return this;
    }

    @Schema(description="An overview and goals of the Agreement.")
    public String getStatementOfIntent() {
        return this.statementOfIntent;
    }

    public void setStatementOfIntent(String statementOfIntent) {
        this.statementOfIntent = statementOfIntent;
    }

    public AgreementCreate status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="The current status of the agreement. Typical values are: in process, approved and rejected.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AgreementCreate typeAgreementCreate(String type) {
        this.typeAgreementCreate = type;
        return this;
    }

    @Schema(description="The type of the agreement. For example \"commercial\".")
    @NotNull
    public String getTypeAgreementCreate() {
        return this.typeAgreementCreate;
    }

    public void setTypeAgreementCreate(String type) {
        this.typeAgreementCreate = type;
    }

    public AgreementCreate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="A string identifying the version of the agreement.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public AgreementCreate agreementSpecification(AgreementSpecificationRef agreementSpecification) {
        this.agreementSpecification = agreementSpecification;
        return this;
    }

    @Schema(description="")
    @Valid
    public AgreementSpecificationRef getAgreementSpecification() {
        return this.agreementSpecification;
    }

    public void setAgreementSpecification(AgreementSpecificationRef agreementSpecification) {
        this.agreementSpecification = agreementSpecification;
    }

    public AgreementCreate agreementItem(List<AgreementItem> agreementItem) {
        this.agreementItem = agreementItem;
        return this;
    }

    public AgreementCreate addAgreementItemItem(AgreementItem agreementItemItem) {
        this.agreementItem.add(agreementItemItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<AgreementItem> getAgreementItem() {
        return this.agreementItem;
    }

    public void setAgreementItem(List<AgreementItem> agreementItem) {
        this.agreementItem = agreementItem;
    }

    public AgreementCreate engagedPartyRole(List<PartyRoleRef> engagedPartyRole) {
        this.engagedPartyRole = engagedPartyRole;
        return this;
    }

    public AgreementCreate addEngagedPartyRoleItem(PartyRoleRef engagedPartyRoleItem) {
        this.engagedPartyRole.add(engagedPartyRoleItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<PartyRoleRef> getEngagedPartyRole() {
        return this.engagedPartyRole;
    }

    public void setEngagedPartyRole(List<PartyRoleRef> engagedPartyRole) {
        this.engagedPartyRole = engagedPartyRole;
    }

    public AgreementCreate agreementAuthorization(List<AgreementAuthorization> agreementAuthorization) {
        this.agreementAuthorization = agreementAuthorization;
        return this;
    }

    public AgreementCreate addAgreementAuthorizationItem(AgreementAuthorization agreementAuthorizationItem) {
        if (this.agreementAuthorization == null) {
            this.agreementAuthorization = new ArrayList<AgreementAuthorization>();
        }
        this.agreementAuthorization.add(agreementAuthorizationItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AgreementAuthorization> getAgreementAuthorization() {
        return this.agreementAuthorization;
    }

    public void setAgreementAuthorization(List<AgreementAuthorization> agreementAuthorization) {
        this.agreementAuthorization = agreementAuthorization;
    }

    public AgreementCreate characteristic(List<Characteristic> characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public AgreementCreate addCharacteristicItem(Characteristic characteristicItem) {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<Characteristic>();
        }
        this.characteristic.add(characteristicItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    public void setCharacteristic(List<Characteristic> characteristic) {
        this.characteristic = characteristic;
    }

    public AgreementCreate associatedAgreement(List<AgreementRef> associatedAgreement) {
        this.associatedAgreement = associatedAgreement;
        return this;
    }

    public AgreementCreate addAssociatedAgreementItem(AgreementRef associatedAgreementItem) {
        if (this.associatedAgreement == null) {
            this.associatedAgreement = new ArrayList<AgreementRef>();
        }
        this.associatedAgreement.add(associatedAgreementItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AgreementRef> getAssociatedAgreement() {
        return this.associatedAgreement;
    }

    public void setAssociatedAgreement(List<AgreementRef> associatedAgreement) {
        this.associatedAgreement = associatedAgreement;
    }

    public AgreementCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AgreementCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public AgreementCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The base type for use in polymorphic collections")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgreementCreate agreementCreate = (AgreementCreate)o;
        return Objects.equals(this.agreementPeriod, agreementCreate.agreementPeriod) && Objects.equals(this.completionDate, agreementCreate.completionDate) && Objects.equals(this.description, agreementCreate.description) && Objects.equals(this.documentNumber, agreementCreate.documentNumber) && Objects.equals(this.initialDate, agreementCreate.initialDate) && Objects.equals(this.name, agreementCreate.name) && Objects.equals(this.statementOfIntent, agreementCreate.statementOfIntent) && Objects.equals(this.status, agreementCreate.status) && Objects.equals(this.type, agreementCreate.type) && Objects.equals(this.version, agreementCreate.version) && Objects.equals(this.agreementSpecification, agreementCreate.agreementSpecification) && Objects.equals(this.agreementItem, agreementCreate.agreementItem) && Objects.equals(this.engagedPartyRole, agreementCreate.engagedPartyRole) && Objects.equals(this.agreementAuthorization, agreementCreate.agreementAuthorization) && Objects.equals(this.characteristic, agreementCreate.characteristic) && Objects.equals(this.associatedAgreement, agreementCreate.associatedAgreement) && Objects.equals(this.type, agreementCreate.type) && Objects.equals(this.schemaLocation, agreementCreate.schemaLocation) && Objects.equals(this.baseType, agreementCreate.baseType);
    }

    public int hashCode() {
        return Objects.hash(this.agreementPeriod, this.completionDate, this.description, this.documentNumber, this.initialDate, this.name, this.statementOfIntent, this.status, this.type, this.version, this.agreementSpecification, this.agreementItem, this.engagedPartyRole, this.agreementAuthorization, this.characteristic, this.associatedAgreement, this.type, this.schemaLocation, this.baseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementCreate {\n");
        sb.append("    agreementPeriod: ").append(this.toIndentedString(this.agreementPeriod)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    documentNumber: ").append(this.toIndentedString(this.documentNumber)).append("\n");
        sb.append("    initialDate: ").append(this.toIndentedString(this.initialDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    statementOfIntent: ").append(this.toIndentedString(this.statementOfIntent)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    agreementSpecification: ").append(this.toIndentedString(this.agreementSpecification)).append("\n");
        sb.append("    agreementItem: ").append(this.toIndentedString(this.agreementItem)).append("\n");
        sb.append("    engagedPartyRole: ").append(this.toIndentedString(this.engagedPartyRole)).append("\n");
        sb.append("    agreementAuthorization: ").append(this.toIndentedString(this.agreementAuthorization)).append("\n");
        sb.append("    characteristic: ").append(this.toIndentedString(this.characteristic)).append("\n");
        sb.append("    associatedAgreement: ").append(this.toIndentedString(this.associatedAgreement)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

