/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am651.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="A business participant that is responsible for approving the agreement.")
@Validated
public class AgreementAuthorization {
    @JsonProperty(value="date")
    private OffsetDateTime date = null;
    @JsonProperty(value="signatureRepresentation")
    private String signatureRepresentation = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="@type")
    private String type = null;

    public AgreementAuthorization date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Schema(description="The date associated with the authorization state.")
    @Valid
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public AgreementAuthorization signatureRepresentation(String signatureRepresentation) {
        this.signatureRepresentation = signatureRepresentation;
        return this;
    }

    @Schema(description="Indication that represents whether the signature is a physical paper signature or a digital signature.")
    public String getSignatureRepresentation() {
        return this.signatureRepresentation;
    }

    public void setSignatureRepresentation(String signatureRepresentation) {
        this.signatureRepresentation = signatureRepresentation;
    }

    public AgreementAuthorization state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current status of the authorization, for example in process, approved, rejected.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AgreementAuthorization type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgreementAuthorization agreementAuthorization = (AgreementAuthorization)o;
        return Objects.equals(this.date, agreementAuthorization.date) && Objects.equals(this.signatureRepresentation, agreementAuthorization.signatureRepresentation) && Objects.equals(this.state, agreementAuthorization.state) && Objects.equals(this.type, agreementAuthorization.type);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.signatureRepresentation, this.state, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementAuthorization {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    signatureRepresentation: ").append(this.toIndentedString(this.signatureRepresentation)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

