/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for ungroup alarms operation Skipped properties: id,href")
@Validated
public class UnGroupAlarmsCreate {
    @JsonProperty(value="alarmChangedTime")
    private OffsetDateTime alarmChangedTime = null;
    @JsonProperty(value="sourceSystemId")
    private String sourceSystemId = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="correlatedAlarm")
    @Valid
    private List<AlarmRefOrValue> correlatedAlarm = new ArrayList<AlarmRefOrValue>();
    @JsonProperty(value="parentAlarm")
    private AlarmRefOrValue parentAlarm = null;
    @JsonProperty(value="unGroupedAlarm")
    @Valid
    private List<AlarmRefOrValue> unGroupedAlarm = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public UnGroupAlarmsCreate alarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
        return this;
    }

    @Schema(description="Time of the uncorrelation")
    @NotNull
    @Valid
    public OffsetDateTime getAlarmChangedTime() {
        return this.alarmChangedTime;
    }

    public void setAlarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
    }

    public UnGroupAlarmsCreate sourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    @Schema(description="Source system identifier")
    @NotNull
    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public UnGroupAlarmsCreate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public UnGroupAlarmsCreate correlatedAlarm(List<AlarmRefOrValue> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
        return this;
    }

    public UnGroupAlarmsCreate addCorrelatedAlarmItem(AlarmRefOrValue correlatedAlarmItem) {
        this.correlatedAlarm.add(correlatedAlarmItem);
        return this;
    }

    @Schema(description="Correlated alarms")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<AlarmRefOrValue> getCorrelatedAlarm() {
        return this.correlatedAlarm;
    }

    public void setCorrelatedAlarm(List<AlarmRefOrValue> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
    }

    public UnGroupAlarmsCreate parentAlarm(AlarmRefOrValue parentAlarm) {
        this.parentAlarm = parentAlarm;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public AlarmRefOrValue getParentAlarm() {
        return this.parentAlarm;
    }

    public void setParentAlarm(AlarmRefOrValue parentAlarm) {
        this.parentAlarm = parentAlarm;
    }

    public UnGroupAlarmsCreate unGroupedAlarm(List<AlarmRefOrValue> unGroupedAlarm) {
        this.unGroupedAlarm = unGroupedAlarm;
        return this;
    }

    public UnGroupAlarmsCreate addUnGroupedAlarmItem(AlarmRefOrValue unGroupedAlarmItem) {
        if (this.unGroupedAlarm == null) {
            this.unGroupedAlarm = new ArrayList<AlarmRefOrValue>();
        }
        this.unGroupedAlarm.add(unGroupedAlarmItem);
        return this;
    }

    @Schema(description="The successfully uncorrelated alarms")
    @Valid
    public List<AlarmRefOrValue> getUnGroupedAlarm() {
        return this.unGroupedAlarm;
    }

    public void setUnGroupedAlarm(List<AlarmRefOrValue> unGroupedAlarm) {
        this.unGroupedAlarm = unGroupedAlarm;
    }

    public UnGroupAlarmsCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public UnGroupAlarmsCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public UnGroupAlarmsCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnGroupAlarmsCreate unGroupAlarmsCreate = (UnGroupAlarmsCreate)o;
        return Objects.equals(this.alarmChangedTime, unGroupAlarmsCreate.alarmChangedTime) && Objects.equals(this.sourceSystemId, unGroupAlarmsCreate.sourceSystemId) && Objects.equals(this.state, unGroupAlarmsCreate.state) && Objects.equals(this.correlatedAlarm, unGroupAlarmsCreate.correlatedAlarm) && Objects.equals(this.parentAlarm, unGroupAlarmsCreate.parentAlarm) && Objects.equals(this.unGroupedAlarm, unGroupAlarmsCreate.unGroupedAlarm) && Objects.equals(this.baseType, unGroupAlarmsCreate.baseType) && Objects.equals(this.schemaLocation, unGroupAlarmsCreate.schemaLocation) && Objects.equals(this.type, unGroupAlarmsCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.alarmChangedTime, this.sourceSystemId, this.state, this.correlatedAlarm, this.parentAlarm, this.unGroupedAlarm, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnGroupAlarmsCreate {\n");
        sb.append("    alarmChangedTime: ").append(this.toIndentedString(this.alarmChangedTime)).append("\n");
        sb.append("    sourceSystemId: ").append(this.toIndentedString(this.sourceSystemId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    correlatedAlarm: ").append(this.toIndentedString(this.correlatedAlarm)).append("\n");
        sb.append("    parentAlarm: ").append(this.toIndentedString(this.parentAlarm)).append("\n");
        sb.append("    unGroupedAlarm: ").append(this.toIndentedString(this.unGroupedAlarm)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

